/*
 * main.cpp
 *
 * Copyright (c) 2007 Fabian Wuertz
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#else
#define PREFIX "/usr"
#endif

#include "kdpkg.h"

#include <tdeapplication.h>
#include <tdeaboutdata.h>
#include <tdecmdlineargs.h>
#include <tdelocale.h>


static TDECmdLineOptions options[] =
{
	{ "+[URL]",   I18N_NOOP("Location to open"), 0 },
	TDECmdLineLastOption
};




int main(int argc, char **argv)
{
	// specify data for About dialog
	TDEAboutData* about = new TDEAboutData("kdpkg", I18N_NOOP("kdpkg"), "");

	about->setProgramLogo( TQImage( PREFIX "/share/icons/hicolor/32x32/apps/kdpkg.png") );
	about->setShortDescription( I18N_NOOP("Frontend for dpkg.") );
	about->setLicense(TDEAboutData::License_GPL_V2);
   about->setHomepage("http://trinity.pearsoncomputing.net");
   about->setBugAddress("http://bugs.pearsoncomputing.net");
	about->setCopyrightStatement("(c) 2010 Timothy Pearson\n(c) 2007 Fabian Würtz");

	about->addAuthor("Timothy Pearson (Trinity Project)", I18N_NOOP("Developer"), "kb9vqf@pearsoncomputing.net", "http://trinity.pearsoncomputing.net");
	about->addAuthor("Fabian Würtz (xadras)", I18N_NOOP("Developer"), "xadras@sidux.com", "http://xadras.wordpress.com/");

	TDECmdLineArgs::init(argc, argv, about);
	TDECmdLineArgs::addCmdLineOptions( options );

	TDEApplication app;
	kdpkg *mainWin = 0;

	if (!app.isRestored())
	{
		// no session.. just start up normally
		TDECmdLineArgs *args = TDECmdLineArgs::parsedArgs();

		TQString url;
		
		for(int i = 0; i < args->count(); i++) // Counting start at 0!
			url = TQString::fromLocal8Bit(args->arg(i));

		//printf(url);

		mainWin = new kdpkg( url );
		app.setMainWidget( mainWin );
		//mainWin->getFile(url);
		mainWin->show();

		args->clear();
	}

	// mainWin has WDestructiveClose flag by default, so it will delete itself.
	return app.exec();
}

