/*
 * Copyright Johannes Sixt
 * This file is licensed under the GNU General Public License Version 2.
 * See the file COPYING in the toplevel directory of the source directory.
 */

#ifndef PgmArgs_included
#define PgmArgs_included

#include "pgmargsbase.h"
#include <ntqlineedit.h>
#include <ntqdict.h>
#include "envvar.h"

class TQStringList;

class PgmArgs : public PgmArgsBase
{
    Q_OBJECT
public:
    PgmArgs(TQWidget* parent, const TQString& pgm, TQDict<EnvVar>& envVars,
	    const TQStringList& allOptions);
    virtual ~PgmArgs();

    void setArgs(const TQString& text) { programArgs->setText(text); }
    TQString args() const { return programArgs->text(); }
    void setOptions(const TQStringList& selectedOptions);
    TQStringList options() const;
    void setWd(const TQString& wd) { wdEdit->setText(wd); }
    TQString wd() const { return wdEdit->text(); }
    TQDict<EnvVar>& envVars() { return m_envVars; }

protected:
    TQDict<EnvVar> m_envVars;

    void initEnvList();
    void parseEnvInput(TQString& name, TQString& value);
    void modifyVar(bool resurrect);

protected slots:
    void modifyVar();
    void deleteVar();
    void envListCurrentChanged();
    void accept();
    void browseWd();
    void browseArgFile();
    void browseArgDir();
    void invokeHelp();
};

#endif // PgmArgs_included
