/***************************************************************************
                          barcodecombo.h  -  description
                             -------------------
    begin                : Son Apr 13 2003
    copyright            : (C) 2003 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef BARCODECOMBO_H
#define BARCODECOMBO_H

#include <tqvalidator.h>
#include <tqwidget.h>
#include <kcombobox.h>

#include "barkode.h"

/** A validator that takes to TQRegExp's to check
 *  whether a barcode is valid or not.
 */
class BarcodeValidator : public TQValidator {
 public:
    BarcodeValidator( TQObject* parent = 0, const char* name = 0 );

    TQValidator::State validate( TQString & input, int & pos ) const;

    /** validate a given input string agains a pattern using 
     *  Perl Compatible Regular Expressions
     *  \param pattern may be NULL
     *  \returns true if the pattern matches
     */
    bool pcreValidate( TQString* pattern, const TQString & input ) const;
    
    inline void setRegExp( TQString* valid, TQString* notValid ) {
        m_valid    = valid;
        m_notValid = notValid;
    }

 private:
    TQString* m_valid;
    TQString* m_notValid;
};

/** A combobox that lists all barcode encodign types
  * supported by KBarcode.
  */
class BarcodeCombo : public KComboBox  {
    Q_OBJECT
  
    public: 
        BarcodeCombo(TQWidget *parent=0, const char *name=0);
        ~BarcodeCombo();

        const char* getEncodingType();
        void setEncodingType( const TQString & type );
};

class KIntNumInput;
class KLineEdit;
class KPushButton;
class KTextEdit;
class TQCheckBox;
class TQLabel;

/** This widget is used in BarCodeDialog and BarcodeSettingsDlg and
  * allows the user to change the data of a barcodeData struct. This powerful
  * widget is always used when the user has to change some property of
  * a barcode.
  *
  * @see BarCodeDialog, @see BarcodeSettingsDlg
  * @author Dominik Seichter
  */
class BarcodeWidget : public TQWidget {
    Q_OBJECT
  
    public:
        BarcodeWidget(TQWidget *parent=0, const char *name=0);
        ~BarcodeWidget() { }

        void getData( Barkode & barkode );
        void setData( const Barkode & b );

        void setStandardEnabled( bool b );
        void setDataEnabled( bool b );

        void defaults();

        inline void setTokenProvider( TokenProvider* token );

    private slots:
        void encodingChanged();
        void advanced();
        void changed();
	void tokens();
        void slotValidateValue();

    private:
        TokenProvider* m_token;

        BarcodeCombo* comboStandard;
        KLineEdit* data;
        BarcodeValidator m_validator;

        KTextEdit* multi;

        KIntNumInput* spinMargin;
        KIntNumInput* spinScale;
        KIntNumInput* spinRotation;
        KIntNumInput* spinCut;
        TQCheckBox* checkText;

        KPushButton* buttonAdvanced;
	KPushButton* buttonToken;

        TQLabel* labelStandard;
        TQLabel* labelData;

        bool m_enabledata;
        bool m_multi;

        Barkode m_barcode;
};

void BarcodeWidget::setTokenProvider( TokenProvider* token )
{
    m_token = token;
}

#endif
