//
// C++ Interface: k9newdvd
//
// Description:
//
//
// Author: Jean-Michel PETIT <k9copy@free.fr>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef K9NEWDVD_H
#define K9NEWDVD_H

#include "k9common.h"
#include <tqobject.h>
#include <tqptrlist.h>
#include <tqdom.h>
#include <tqdatetime.h>
#include "k9process.h"
#include "k9progress.h"
#include "k9avidecode.h"
#include "k9config.h"


/**
	@author Jean-Michel PETIT <k9copy@free.fr>
*/
class k9Title;
class k9AviFile;
class k9Menu;
class k9ProcessList;
class k9NewDVDItems : public TQPtrList<k9Title> {
protected:
    virtual int compareItems ( TQPtrCollection::Item item1,TQPtrCollection::Item item2 );
};

class k9NewDVD : public TQObject {
    Q_OBJECT
  
public:
    enum eFormat {NTSC=2,PAL=1};
    k9NewDVD ( TQObject *parent = 0, const char *name = 0 );
    ~k9NewDVD();
    k9NewDVDItems* getTitles() {
        return &m_titles;
    }
    eFormat m_format;

    void execute();
    void createXML();
    void addTitles ( TQDomElement &_root );
    void setFormat ( const eFormat& _value );

    void setWorkDir ( const TQString& _value );
    void appendTitle ( k9Title *_title );

    void setProcessList(k9ProcessList *_value);
    eFormat getFormat() const;

    int getTotalTime();
    k9Menu* getRootMenu() const;

    TQString getError() const;

private:
    k9NewDVDItems m_titles;
    TQStringList m_tmpFiles;
    TQDomDocument *m_xml;
    TQString m_workDir;
    k9ProcessList *m_processList;
    TQTime m_timer;
    TQTime m_timer2;
    TQTime m_timer3;
    k9Menu *m_rootMenu;
    bool m_cancel;
    TQString m_error;
    TQString m_stdout;
    int m_videoBitrate;
    k9AviDecode m_aviDecode;
    int m_totalEncodedSize;
    int m_offset;
    int m_lastvalue;
    TQMap <k9Process*,TQTime> m_timers;
    void calcVideoBitrate();
    void createMencoderCmd ( TQString &_cmd,TQString &_chapters, k9AviFile *_aviFile );
    k9Config *m_config;
protected slots:
    void getStdout ( TDEProcess *, char *, int );
    void getStderr ( TDEProcess *, char *, int );
    void drawImage ( TQImage * _image );
signals:
    void sigAddTitle();
};

#endif
