/* 
 *
 * $Id: k3bmiscoptiontab.cpp 619556 2007-01-03 17:38:12Z trueg $
 * Copyright (C) 2003 Sebastian Trueg <trueg@k3b.org>
 *
 * This file is part of the K3b project.
 * Copyright (C) 1998-2007 Sebastian Trueg <trueg@k3b.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * See the file "COPYING" for the exact licensing terms.
 */


#include "k3bmiscoptiontab.h"

#include <k3bpluginmanager.h>
#include <k3baudiooutputplugin.h>
#include <k3baudioserver.h>
#include <k3bcore.h>
#include <k3bservicemenuinstaller.h>
#include <k3binteractiondialog.h>
#include <k3bintmapcombobox.h>

#include <tqcheckbox.h>
#include <tqfileinfo.h>
#include <tqradiobutton.h>

#include <tdeapplication.h>
#include <tdelocale.h>
#include <tdeconfig.h>
#include <kdialog.h>
#include <kstandarddirs.h>
#include <tdemessagebox.h>
#include <kurlrequester.h>
#include <kcombobox.h>


K3bMiscOptionTab::K3bMiscOptionTab(TQWidget *parent, const char *name )
  : base_K3bMiscOptionTab(parent,name)
{
  m_editTempDir->setMode( KFile::Directory );
  connect( m_buttonConfigureAudioOutput, TQT_SIGNAL(clicked()),
	   this, TQT_SLOT(slotConfigureAudioOutput()) );

  m_comboActionDialogSettings->insertItem( K3bInteractionDialog::LOAD_K3B_DEFAULTS, 
					   i18n("Default Settings"),
					   i18n("Load the K3b Defaults at dialog startup.") );
  m_comboActionDialogSettings->insertItem( K3bInteractionDialog::LOAD_SAVED_SETTINGS, 
					   i18n("Saved Settings"),
					   i18n("Load the settings saved by the user at dialog startup.") );
  m_comboActionDialogSettings->insertItem( K3bInteractionDialog::LOAD_LAST_SETTINGS, 
					   i18n("Last Used Settings"),
					   i18n("Load the last used settings at dialog startup.") );
  m_comboActionDialogSettings->addGlobalWhatsThisText( i18n("K3b handles three sets of settings in action dialogs "
							    "(action dialogs include the CD Copy dialog or the Audio CD "
							    "project dialog):"),
						       i18n("One of these sets is loaded once an action dialog is opened. "
							    "This setting defines which set it will be.") );
}


K3bMiscOptionTab::~K3bMiscOptionTab()
{
}


void K3bMiscOptionTab::readSettings()
{
  TDEConfig* c = kapp->config();
  c->setGroup( "General Options" );
  m_checkSaveOnExit->setChecked( c->readBoolEntry( "ask_for_saving_changes_on_exit", true ) );
  m_checkShowSplash->setChecked( c->readBoolEntry("Show splash", true) );
  m_checkShowProgressOSD->setChecked( c->readBoolEntry( "Show progress OSD", true ) );
  m_checkHideMainWindowWhileWriting->setChecked( c->readBoolEntry( "hide main window while writing", false ) );
  m_checkKeepDialogsOpen->setChecked( c->readBoolEntry( "keep action dialogs open", false ) );
  m_comboActionDialogSettings->setSelectedValue( c->readNumEntry( "action dialog startup settings", 
								  K3bInteractionDialog::LOAD_SAVED_SETTINGS ) );
  m_checkSystemConfig->setChecked( c->readBoolEntry( "check system config", true ) );

  TQString tempdir = c->readPathEntry( "Temp Dir", TDEGlobal::dirs()->resourceDirs( "tmp" ).first() );
  m_editTempDir->setURL( tempdir );

//   if( c->readEntry( "Multiple Instances", "smart" ) == "smart" )
//     m_radioMultipleInstancesSmart->setChecked(true);
//   else
//     m_radioMultipleInstancesNew->setChecked(true);

  // Audio Output
  m_comboAudioOutputSystem->clear();
  TQPtrList<K3bPlugin> fl = k3bcore->pluginManager()->plugins( "AudioOutput" );
  for( TQPtrListIterator<K3bPlugin> it( fl ); it.current(); ++it ) {
    K3bAudioOutputPlugin* f = static_cast<K3bAudioOutputPlugin*>( it.current() );
    m_comboAudioOutputSystem->insertItem( TQString(TQString::fromLocal8Bit(f->soundSystem())) );
  }

  m_comboAudioOutputSystem->setCurrentItem( c->readEntry( "Audio Output System", "arts" ), false );
  m_buttonConfigureAudioOutput->setEnabled( m_comboAudioOutputSystem->count() > 0 );

  K3bServiceInstaller si;
  m_checkKonqiIntegration->setChecked( si.allInstalled() );
}


bool K3bMiscOptionTab::saveSettings()
{
  TDEConfig* c = kapp->config();
  c->setGroup( "General Options" );
  c->writeEntry( "ask_for_saving_changes_on_exit", m_checkSaveOnExit->isChecked() );
  c->writeEntry( "Show splash", m_checkShowSplash->isChecked() );
  c->writeEntry( "Show progress OSD", m_checkShowProgressOSD->isChecked() );
  c->writeEntry( "hide main window while writing", m_checkHideMainWindowWhileWriting->isChecked() );
  c->writeEntry( "keep action dialogs open", m_checkKeepDialogsOpen->isChecked() );
  c->writeEntry( "check system config", m_checkSystemConfig->isChecked() );
  c->writeEntry( "action dialog startup settings", m_comboActionDialogSettings->selectedValue() );

  TQString tempDir = m_editTempDir->url();
  TQFileInfo fi( tempDir );

  if( fi.isRelative() ) {
    fi.setFile( fi.absFilePath() );
  }

  if( !fi.exists() ) {
    if( KMessageBox::questionYesNo( this, i18n("Directory (%1) does not exist. Create?").arg(tempDir),
				    i18n("Create Directory"), i18n("Create"), KStdGuiItem::cancel() ) == KMessageBox::Yes ) {
      if( !TDEStandardDirs::makeDir( fi.absFilePath() ) ) {
	KMessageBox::error( this, i18n("Unable to create directory %1").arg(tempDir) );
	return false;
      }
    }
    else {
      // the dir does not exist and the user doesn't want to create it
      return false;
    }
  }

  if( fi.isFile() ) {
    KMessageBox::information( this, i18n("You specified a file for the temporary directory. "
					 "K3b will use its base path as the temporary directory."), 
			      i18n("Warning"), 
			      "temp file only using base path" );
    fi.setFile( fi.dirPath() );
  }

  // check for writing permission
  if( !fi.isWritable() ) {
    KMessageBox::error( this, i18n("You do not have permission to write to %1.").arg(fi.absFilePath()) );
    return false;
  }

  m_editTempDir->setURL( fi.absFilePath() );

  c->writePathEntry( "Temp Dir", m_editTempDir->url() );

//   if( m_radioMultipleInstancesSmart->isChecked() )
//     c->writeEntry( "Multiple Instances", "smart" );
//   else
//     c->writeEntry( "Multiple Instances", "always_new" );

  // Audio Output System
  if( m_comboAudioOutputSystem->count() > 0 ) {
    c->writeEntry( "Audio Output System", m_comboAudioOutputSystem->currentText() );
    K3bAudioServer::instance()->setOutputMethod( m_comboAudioOutputSystem->currentText().local8Bit() );
  }

  K3bServiceInstaller si;
  if( m_checkKonqiIntegration->isChecked() )
    si.install( this );
  else
    si.remove( this );

  return true;
}


void K3bMiscOptionTab::slotConfigureAudioOutput()
{
  TQString system = m_comboAudioOutputSystem->currentText();
  if( K3bAudioOutputPlugin* plugin = K3bAudioServer::findOutputPlugin( system.local8Bit() ) ) {
    k3bcore->pluginManager()->execPluginDialog( plugin, this );
  }
}

#include "k3bmiscoptiontab.moc"
