/*
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
*/

/*
  tracktooltip.h  -  Provides an interface to a plain TQWidget, which is independent of KDE (bypassed to X11)
  begin:     Tue 10 Feb 2004
  copyright: (C) 2004 by Christian Muehlhaeuser
  email:     chris@chris.de
*/

#ifndef TRACKTOOLTIP_H
#define TRACKTOOLTIP_H

#include <tqobject.h>
#include <tqptrlist.h>
#include <metabundle.h>

#include "tooltip.h"

class TQWidget;

class TrackToolTip: public TQObject, public Amarok::ToolTipClient
{
    Q_OBJECT
  

    public:
    TrackToolTip();
    static TrackToolTip* instance();

    void addToWidget( TQWidget *widget );
    void removeFromWidget( TQWidget *widget );

    void setTrack( const MetaBundle &tags, bool force = false );
    void setPos( int pos );
    void clear();

    public:
    virtual TQPair<TQString, TQRect> toolTipText( TQWidget*, const TQPoint& ) const;

    private slots:
    void slotCoverChanged( const TQString &artist, const TQString &album );
    void slotImageChanged( const TQString &remoteURL );
    void slotUpdate( const TQString &url = TQString() );
    void slotMoodbarEvent( void );

    private:
    TQString tooltip() const;
    void updateWidgets();

    static TrackToolTip *s_instance;
    TQPtrList<TQWidget> m_widgets;
    MetaBundle m_tags;
    int        m_pos;
    TQString    m_cover;
    TQString    m_tooltip;
    bool       m_haspos;
    TQString    m_moodbarURL;
};

#endif
