#ifndef _STDINREADER_H_
#define _STDINREADER_H_

/*
 *   Copyright (C) 2005 by Ian Monroe <ian@monroe.nu>
 *   Released under GPL 2 or later, see COPYING
 */
#include <tqsocketnotifier.h>
#include <tqtextstream.h>
#include <kdebug.h>

class StdinReader : public TQObject
{
    Q_OBJECT
    

public:
    StdinReader(TQObject * parent = 0, const char * name = 0)
    :TQObject(parent,name)
    {
        TQSocketNotifier* streamListener = new TQSocketNotifier(0, TQSocketNotifier::Read, this, "stdinWatcher");
        connect(streamListener, TQT_SIGNAL(activated(int)), this, TQT_SLOT(dataRecieved()) );

    }
    ~StdinReader() { }
    signals:
        void openWindow();
    public slots:
    void dataRecieved()
    {
        //separate stdin pointer necesary for OS X for reasons unknown
        FILE * stdin_ptr = stdin;
        TQString signal;
        TQTextIStream( stdin_ptr ) >> signal;
        if(signal == "configure")
            emit openWindow();
    }
    
    
};

#endif

