/*
 *   Copyright (C) 2005 by Ian Monroe <ian@monroe.nu>
 *   Released under GPL 2 or later, see COPYING
 */


#ifndef _EQUALIZERCANVASVIEW_H_
#define _EQUALIZERCANVASVIEW_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#include <tqcanvas.h>
#include <tqpen.h>
#include <tqslider.h>

#endif

#include <tdemainwindow.h>

class EqualizerCircle : public TQCanvasEllipse
{

public:
    enum { RTTI = 1001 };
    
    
    EqualizerCircle(int x, int y, TQCanvas *canvas, TQCanvasLine* line1, TQCanvasLine* line2, TQPtrList<EqualizerCircle>* circleList ); 
    void setLocation(const TQPoint &newLocation);
    int rtti() { return RTTI; }
private:
    enum WhichLine { LEFT = 1, RIGHT = 2 }; 
    void setLine(WhichLine lineNum, TQCanvasLine* line);

    TQCanvasLine *m_line1;
    TQCanvasLine *m_line2;
    TQPtrList<EqualizerCircle>* m_circleList;
};

/**
 * @short An equalizer widget for Amarok, using a line graph
 * @author Ian Monroe <ian@monroe.nu>
 */
class EqualizerCanvasView : public TQCanvasView
{
    Q_OBJECT
  
public:
    EqualizerCanvasView(TQWidget *parent, const char *name);
    void init();
    void contentsMousePressEvent(TQMouseEvent *event);
    void contentsMouseDoubleClickEvent(TQMouseEvent *event);
    void contentsMouseMoveEvent(TQMouseEvent *event);
    void contentsMouseReleaseEvent(TQMouseEvent *event);
    TQValueList<int> currentSettings();
signals:
    void eqChanged();
private:
    int getY(int xCoord);
    TQCanvasLine* makeLine(TQPoint startPoint, TQPoint endPoint);
    TQPen m_pen;
    TQCanvasItem* m_selectedItem;
    TQPtrList<EqualizerCircle>* m_circleList;
};

class CallAmarok : public TQObject
{
    Q_OBJECT
  
public:
    CallAmarok(TQObject* parent, const char *name,
        EqualizerCanvasView* canvasView, TQSlider* preampSlider) 
    : TQObject(parent, name) 
    {
        m_canvasView = canvasView;
        m_preampSlider = preampSlider;
    }
public slots:
    void updateEq();
private:
    TQSlider* m_preampSlider;
    EqualizerCanvasView* m_canvasView;
};

#endif // _EQUALIZERCANVASVIEW_H_
