/* -*- C++ -*- */
#ifndef TESTUI_APP_H
#define TESTUI_APP_H

#include <tdemainwindow.h>
#include <tdeparts/part.h>
#include <tdeactionclasses.h>
#include <apt-front/cache/observer.h>
#include <apt-front/cache/component/state.h>
#include <apt-front/cache/component/history.h>
#include <adept/view.h>
#include <adept/commitprogress.h>
#include <adept/application.h>

class TQVBox;
class TQWidgetStack;
class TQSplitter;
class TDEAction;
class KPushButton;
namespace adept {
class AcqProgressWidget;
}

using namespace aptFront;
using namespace adept;

class TestApp : public TDEMainWindow, Application {
    Q_OBJECT
  
public:
    void setupActions();
    ExtTerminalInterface *terminal();
	TestApp();
protected slots:
    void start();
    void update();
    void postUpdate();
    void commit();

    void delayed();

    void undo() { Application::undo(); }
    void redo() { Application::redo(); }
    void checkpoint() { Application::checkpoint(); }

    void setHistoryEnabled( bool );

    void disableNext();
    void disableButtons();
    void setNext( TQString str, const char *slot,
                  TQString qstr = i18n( "Forget Changes and Quit" ),
                  const char *qslot = TQT_SLOT( close() ) );
protected:
    friend class WaitForLister;

    virtual void notifyPostChange( cache::component::Base * );
    virtual void notifyPreChange( cache::component::Base * );

    TQWidgetStack *m_stack;
    TQVBox *m_all;
    TQHBox *m_buttons;
    TQLabel *m_start, *m_bye, *m_loading;
    KPushButton *m_next, *m_quit;

    // stacked widgets
    adept::AcqProgressWidget *m_progress;
    adept::CommitProgress *m_commitProgress;
    adept::Browser *m_list;

    // other stuff
    std::vector<TDEAction *> m_actions;
    TQMap< TQString, TQString > m_icons;
    TDEAction *m_undo, *m_redo;
    cache::component::History< cache::component::State > *m_history;
};

class WaitForLister : public TQObject {
    Q_OBJECT
  
public:
    WaitForLister( TestApp *a, const char *s )
        : app( a ), slot( s )
        {
            waiting();
        }
protected slots:
    void waiting();
protected:
    TestApp *app;
    const char *slot;

};

#endif
