/* -*- C++ -*- */
#ifndef TESTUI_APP_H
#define TESTUI_APP_H

#include <tdemainwindow.h>
#include <tdeparts/part.h>
#include <tdeactionclasses.h>
#include <apt-front/cache/observer.h>
#include <apt-front/cache/component/state.h>
#include <apt-front/cache/component/history.h>
#include <adept/view.h>
#include <adept/commitprogress.h>
#include <adept/sourceseditor.h>
#include <adept/application.h>

class TQVBox;
class TQWidgetStack;
class TQSplitter;
class TDEAction;
namespace adept {
class AcqProgressWidget;
}

using namespace aptFront;
using namespace adept;

class TestApp : public TDEMainWindow, Application {
    Q_OBJECT
  
public:
    enum Mode { Default, Sources, Preview, Download, Commit };
    void setupActions();
    ExtTerminalInterface *terminal();
	TestApp();
protected slots:
    void delayed(); // initialisation

    void setActionsEnabled( bool );
    void setHistoryEnabled( bool );

    void update(); // actions
    void upgrade();
    void distUpgrade();
    void commit();

    void reload(); // debugging

    void undo() { Application::undo(); }
    void redo() { Application::redo(); }
    void checkpoint() { Application::checkpoint(); }

    void foregroundClosed();

    void togglePreview();
    void toggleSources();
    void toggleDownload();
    void toggleCommit();

    void closePreview();
    void closeSources();

    void openPreview();
    void openSources();

    bool modeActive( Mode m ) {
        // return modeAction( m )->isChecked();
        return modeWidget( m ) == m_stack->visibleWidget();
    }

    void closeModes() {
        closePreview();
        closeSources();
        closeMode( Download );
        closeMode( Commit );
        m_modesClosed->setChecked( true );
    }

    void rebuildStarted() {
        if ( !m_rebuilds ) setActionsEnabled( false );
        m_rebuilds ++;
    }

    void rebuildFinished() {
        m_rebuilds --;
        if ( !m_rebuilds ) setActionsEnabled( true );
    }

protected:
    void updateActionState();
    void guardLister( adept::Lister * );
    void addMode( Mode m, TDEToggleAction *a, TQWidget *w ) {
        m_modeActionMap[ m ] = a;
        m_modeWidgetMap[ m ] = w;
        a->setChecked( false );
    }

    TDEToggleAction *modeAction( Mode m ) {
        return m_modeActionMap[ m ];
    }

    TQWidget *modeWidget( Mode m ) {
        return m_modeWidgetMap[ m ];
    }

    bool openMode( Mode );
    bool closeMode( Mode );
    void toggleMode( Mode );

    friend class WaitForLister;
    virtual void closeEvent( TQCloseEvent * );
    virtual void notifyPostChange( cache::component::Base * );
    virtual void notifyPostRebuild( cache::component::Base * );
    virtual void notifyPreChange( cache::component::Base * );

    TQWidgetStack *m_stack;
    TQLabel *m_loading;

    // stacked widgets
    adept::AcqProgressWidget *m_progress;
    adept::Browser *m_list, *m_preview;
    adept::SourcesEditor *m_sources;
    adept::CommitProgress *m_commitProgress;

    // other stuff
    std::vector<TDEAction *> m_actions;
    TQMap< TQString, TQString > m_icons;
    TDEAction *m_undo, *m_redo;

    int m_rebuilds;
    bool m_actionsEnabled;

    TDEAction *m_commit, *m_upgrade, *m_distUpgrade;
    TDEToggleAction *m_sourcesAction, *m_commitProgressAction, *m_listAction,
        *m_previewAction, *m_progressAction;
    std::map< Mode, TDEToggleAction * > m_modeActionMap;
    std::map< Mode, TQWidget * > m_modeWidgetMap;
    TDEToggleAction *m_modesClosed;
private:
    template<typename T> void plugAptActions();
    // template<typename T, typename In> void updateAptActions( In b, In e );
    template<typename T, typename In> void aptAction( In b, In e );
};

#endif
