#include <cstddef>
#include <apt-front/predicate/combinators.h>
#include <apt-front/predicate/factory.h>
#include <tdelocale.h>
#include <kdebug.h>
#include <tqcheckbox.h>
#include <tqobjectlist.h>
#include "statefilter.h"

using namespace aptFront;
using namespace adept;

StateFilterWidget::StateFilterWidget( TQWidget *parent, const char *name )
    : StateFilterUi( parent, name )
{
    TQObjectList *chld = queryList( TQCHECKBOX_OBJECT_NAME_STRING );
    TQObjectListIt it( *chld );
    while( it.current() != 0 ) {
        connect( it.current(), TQT_SIGNAL( toggled( bool )  ),
                 this, TQT_SLOT( widgetsChanged() ) );
        ++it;
    }
}

StateFilterWidget::Predicate StateFilterWidget::predicate()
{
    typedef StateFilter< entity::Package > F;
    unsigned mask = 0;
    if (m_installed->isChecked()) mask |= F::Installed;
    if (m_notInstalled->isChecked()) mask |= F::NotInstalled;
    if (m_upgradable->isChecked()) mask |= F::Upgradable;
    if (m_keep->isChecked()) mask |= F::Keep;
    if (m_install->isChecked()) mask |= F::Install;
    if (m_remove->isChecked()) mask |= F::Remove;
    if (m_upgrade->isChecked()) mask |= F::Upgrade;

    StateFilter< entity::Package > f;
    f.setMask( mask );
    return predicate::adapt< entity::Entity >( f );
}

static void blockedSet( TQCheckBox *b, bool v ) {
    b->blockSignals( true );
    b->setChecked( v );
    b->blockSignals( false );
}

void StateFilterWidget::predicateChanged()
{
    typedef StateFilter< entity::Package > F;
    F f = downcast< F >( m_pred );
    unsigned mask = f.mask();
    blockedSet( m_installed, mask & F::Installed );
    blockedSet( m_notInstalled, mask & F::NotInstalled );
    blockedSet( m_upgradable, mask & F::Upgradable );
    blockedSet( m_keep, mask & F::Keep );
    blockedSet( m_install, mask & F::Install );
    blockedSet( m_upgrade, mask & F::Upgrade );
    blockedSet( m_remove, mask & F::Remove );
}

