/** -*- C++ -*-
	@file adept/dpkgpm.h
	@author Peter Rockai <me@mornfall.net>
*/

#include <apt-pkg/dpkgpm.h>
#include <string>
#include <vector>
#include <map>

#ifndef DPKGPM_H
#  define DPKGPM_H

namespace aptFront {

class DPkgPM : public pkgDPkgPM {
protected:
    enum Op { ORemove, OPurge, OConfigure, OInstall };
    Op m_currentOp;
    int m_dpkgPipe[2];
    int m_scriptPipe[2];
    unsigned m_version;
    std::string m_statusBuffer;
    typedef std::pair< Op, std::string > OpAndStatus;
    typedef std::map< std::pair< OpAndStatus, std::string >, int > SeenOps;
    SeenOps m_seenOps;
    int m_totalOpCount;
    int m_seenOpCount;
public:
    DPkgPM (pkgDepCache *C);
    virtual bool Go ( int );
    virtual void computeTotals();
    virtual bool setupArgs (char *const **a, std::vector<Item>::iterator &I);
    virtual bool forkDpkg (char *const argv[]);
    virtual bool forkScript (const char *, bool);
    virtual bool runScripts (const char *, bool);
    virtual bool setupChild ();
    virtual void setupScript (const char *, bool);
    virtual void dpkgMonitor (void);
    virtual bool SendV1Pkgs (FILE *);
    virtual bool feedPackages (void);
    virtual void updateStatus( std::string pkg, std::string ev, std::string r );
};

}


#endif /* ifndef DPKGPM_H */

