import org.trinitydesktop.qt.*;

public class CannonField extends TQWidget {
	private int ang;
	private int f;
	
	public CannonField(TQWidget parent, String name) {
		super(parent, name);
		ang = 45;
		setPalette(new TQPalette(new TQColor(250, 250, 200)));
	}

	public int angle() {
		return ang;
	}

	public void setAngle(int degrees) {
		if (degrees < 5)
			degrees = 5;
		if (degrees > 70)
			degrees = 70;
		if (ang == degrees)
			return;
		ang = degrees;
		repaint();
		emit("angleChanged", ang);
	}

	public int force() {
		return f;
	}

	public void setForce(int newton) {
		if (newton < 0)
			newton = 0;
		if (f == newton)
			return;
		f = newton;
		emit("forceChanged", f);
	}

	private TQRect cannonRect() {
		TQRect r = new TQRect(0, 0, 50, 50);
		r.moveBottomLeft(rect().bottomLeft());
		return r;
	}

	public void paintEvent(TQPaintEvent e) {
		if (!e.rect().intersects(cannonRect()))
			return;

		TQRect cr = cannonRect();
		TQPixmap pix = new TQPixmap(cr.size());
		pix.fill(new TQColor(250, 250, 200));

		TQPainter p = new TQPainter(pix);
		p.setBrush(blue());
		p.setPen(NoPen);
		p.translate(0, pix.height() - 1);
		p.drawPie(new TQRect(-35,-35, 70, 70), 0, 90*16);
		p.rotate(-ang);
		p.drawRect(new TQRect(33, -4, 15, 8));
		p.end();

		p.begin(this);
		p.drawPixmap(cr.topLeft(), pix);
	}

	public TQSizePolicy sizePolicy() {
		return new TQSizePolicy(TQSizePolicy.Expanding, TQSizePolicy.Expanding);
	}
}
