/***************************************************************************
* $Id$
**
* Definition of something or other
**
* Created : 979899
**
* Copyright (C) 1997 by Trolltech AS.  All rights reserved.
**
* This file is part of an example program for Qt.  This example
* program may be used, distributed and modified without limitation.
**
****************************************************************************/


import org.trinitydesktop.qt.*;

class WidgetView  extends TQMainWindow
{

private String MOVIEFILENAME = "trolltech.gif";
private TQLabel     msg;
private TQCheckBox  cb[] = new TQCheckBox[3];
private TQGroupBox bg;
private TQLabel     movielabel;
private TQMovie      movie;
private TQWidget central;
private TQProgressBar prog;
private int progress;
private TQTabWidget tabs;
private TQMultiLineEdit edit;
private TQPopupMenu textStylePopup;
private int plainStyleID;
private TQWidget bla;
private AnalogClock aclock;
private DigitalClock dclock;

/* XPM */
static String[] filesave = {
"    14    14        4            1",
". c #040404",
"# c #808304",
"a c #bfc2bf",
"b c None",
"..............",
".#.aaaaaaaa.a.",
".#.aaaaaaaa...",
".#.aaaaaaaa.#.",
".#.aaaaaaaa.#.",
".#.aaaaaaaa.#.",
".#.aaaaaaaa.#.",
".##........##.",
".############.",
".##.........#.",
".##......aa.#.",
".##......aa.#.",
".##......aa.#.",
"b............."
};

/* XPM */
static String[] fileopen = {
"    16    13        5            1",
". c #040404",
"# c #808304",
"a c None",
"b c #f3f704",
"c c #f3f7f3",
"aaaaaaaaa...aaaa",
"aaaaaaaa.aaa.a.a",
"aaaaaaaaaaaaa..a",
"a...aaaaaaaa...a",
".bcb.......aaaaa",
".cbcbcbcbc.aaaaa",
".bcbcbcbcb.aaaaa",
".cbcb...........",
".bcb.#########.a",
".cb.#########.aa",
".b.#########.aaa",
"..#########.aaaa",
"...........aaaaa"
};

/* XPM */
static String[] fileprint = {
"    16    14        6            1",
". c #000000",
"# c #848284",
"a c #c6c3c6",
"b c #ffff00",
"c c #ffffff",
"d c None",
"ddddd.........dd",
"dddd.cccccccc.dd",
"dddd.c.....c.ddd",
"ddd.cccccccc.ddd",
"ddd.c.....c....d",
"dd.cccccccc.a.a.",
"d..........a.a..",
".aaaaaaaaaa.a.a.",
".............aa.",
".aaaaaa###aa.a.d",
".aaaaaabbbaa...d",
".............a.d",
"d.aaaaaaaaa.a.dd",
"dd...........ddd"
};

// Standard Qt widgets



class MyListView  extends TQListView
{
public    MyListView( TQWidget  parent )
{
	this(parent, null);
}
public    MyListView( TQWidget  parent, String name )
{
    super( parent, name );
	selected = null;
}
protected void contentsMousePressEvent( TQMouseEvent  e )
    {
	selected = selectedItem();
//	super.contentsMousePressEvent( e );
    }
protected void contentsMouseReleaseEvent( TQMouseEvent  e )
    {
//	super.contentsMouseReleaseEvent( e );
	if ( selectedItem() != selected ) {
	    emit("mySelectionChanged", selectedItem() );
	    emit("mySelectionChanged");
	}
    }

private    TQListViewItem selected;
}
//
// WidgetView contains lots of Qt widgets.
//



// Some sample widgets





/*
class MyWhatsThis  extends TQWhatsThis
{
public    MyWhatsThis( TQListBox lb)
{
    super( lb );
	listbox = lb; 
}


public  String text( TQPoint  p) {
	TQListBoxItem i = listbox.itemAt( p );
	if ( i != null && i.pixmap() != null ) {
	    return "Isn't that a <em>wonderful</em> pixmap? <br>"
		+ "Imagine, you could even decorate a"
		+ " <b>red</b> pushbutton with it! :-)";
	}
	return "This is a TQListBox.";
    }

private    TQListBox listbox;
}


class MyMenuItem  extends TQCustomMenuItem
{
public    MyMenuItem( String s, TQFont f )
{
	string = s;
	font = f;
}

    public void paint( TQPainter p, TQColorGroup cg, boolean act,
		boolean enabled, int x, int y, int w, int h )
    {
	p.setFont ( font );
	p.drawText( x, y, w, h,
		     AlignAuto | AlignVCenter | ShowPrefix | DontClip,
		     string );
    }

    public TQSize sizeHint()
    {
	return TQFontMetrics( font ).size( AlignAuto | AlignVCenter |
					  ShowPrefix | DontClip,  string );
    }
private    String string;
private    TQFont font;
}
*/


//
// Construct the WidgetView with children
//

WidgetView( TQWidget parent, String name )
{
    super( parent, name );
    TQColor col = new TQColor();

    // Set the window caption/title
    setCaption( "Qt Example - Widgets Demo Application" );

    // create a toolbar
    TQToolBar tools = new TQToolBar( this, "toolbar" );

    // put something in it
    TQPixmap openIcon = new TQPixmap( fileopen );
    TQToolButton  toolb = new TQToolButton( new TQIconSet(openIcon), "toolbutton 1",
					   "", this, SLOT("open()"),
					   tools, "open file" );
    TQWhatsThis.add( toolb, "This is a <b>TQToolButton</b>. It lives in a "
		     + "TQToolBar. This particular button doesn't do anything "
		     + "useful." );

    TQPixmap saveIcon = new TQPixmap( filesave );
    toolb = new TQToolButton( new TQIconSet(saveIcon), "toolbutton 2", "",
			     this, SLOT("dummy()"),
			     tools, "save file" );
    TQWhatsThis.add( toolb, "This is also a <b>TQToolButton</b>." );

    TQPixmap  printIcon = new TQPixmap( fileprint );
    toolb = new TQToolButton( new TQIconSet(printIcon), "toolbutton 3", "",
			     this, SLOT("dummy()"),
			     tools, "print file" );
    TQWhatsThis.add( toolb, "This is the third <b>TQToolButton</b>.");

    toolb = TQWhatsThis.whatsThisButton( tools );
    TQWhatsThis.add( toolb, "This is a <b>What's This</b> button "
		     + "It enables the user to ask for help "
		     + "about widgets on the screen.");

    // Install an application-global event filter to catch control+leftbutton
    tqApp().installEventFilter( this );

    //make a central widget to contain the other widgets
    central = new TQWidget( this );
    setCentralWidget( central );

    // Create a layout to position the widgets
    TQHBoxLayout topLayout = new TQHBoxLayout( central, 10 );

    // Create a grid layout to hold most of the widgets
    TQGridLayout grid = new TQGridLayout( 0, 3 ); //3 wide and autodetect number of rows
    topLayout.addLayout( grid, 1 );

    // Create an easter egg
    TQToolTip.add( menuBar(), new TQRect( 0, 0, 2, 2 ), "easter egg" );

    TQPopupMenu popup;
    popup = new TQPopupMenu( this );
    menuBar().insertItem( "&File", popup );
    int id;
    id = popup.insertItem( "&New" );
    popup.setItemEnabled( id, false );
    id = popup.insertItem( new TQIconSet(openIcon), "&Open", this, SLOT(" open()") );

    popup.insertSeparator();
    popup.insertItem( "&Quit", tqApp(), SLOT("quit()"), new TQKeySequence(CTRL+Key_Q) );


    textStylePopup = popup = new TQPopupMenu( this );
    menuBar().insertItem( "&Edit", popup );

    plainStyleID = id = popup.insertItem( "&Plain" );
    popup.setAccel( new TQKeySequence(CTRL+Key_T), id );

    popup.insertSeparator();
/*    TQFont f = font();
    f.setBold( true );
    id = popup.insertItem( new MyMenuItem( "&Bold", f ) );
    popup.setAccel( new TQKeySequence(CTRL+Key_B), id );
    f = font();
    f.setItalic( true );
    id = popup.insertItem( new MyMenuItem( "&Italic", f ) );
    popup.setItemChecked( id, true );
    popup.setAccel( new TQKeySequence(CTRL+Key_I), id );
    f = font();
    f.setUnderline( true );
    id = popup.insertItem( new MyMenuItem( "&Underline", f ) );
    popup.setAccel( new TQKeySequence(CTRL+Key_U), id );
    f = font();
    f.setStrikeOut( true );
    id = popup.insertItem( new MyMenuItem( "&Strike", f ) );
    connect( textStylePopup, SIGNAL("activated(int)"),
	     this, SLOT("popupSelected(int)") );
*/
    // Create an analog and a digital clock
    aclock = new AnalogClock( central );
    aclock.setAutoMask( true );
    dclock = new DigitalClock( central );
    dclock.setMaximumWidth(200);
    grid.addWidget( aclock, 0, 2 );
    grid.addWidget( dclock, 1, 2 );

    // Give the dclock widget a blue palette
    col.setRgb( 0xaa, 0xbe, 0xff );
    dclock.setPalette( new TQPalette( col ) );

    // make tool tips for both of them
    TQToolTip.add( aclock, "custom widget: analog clock" );
    TQToolTip.add( dclock, "custom widget: digital clock" );

    // Create a push button.
    TQPushButton pb;
    pb = new TQPushButton( "&Push button 1", central, "button1" );
    grid.addWidget( pb, 0, 0, AlignVCenter );
    connect( pb, SIGNAL("clicked()"), SLOT("button1Clicked()") );
    TQToolTip.add( pb, "push button 1" );
    TQWhatsThis.add( pb, "This is a <b>TQPushButton</b>.<br>"
		     + "Click it and watch...<br>"
		     + "The wonders of modern technology.");

    TQPixmap pm = new TQPixmap();
    boolean pix = pm.load("qt.png");
    if ( !pix ) {
	TQMessageBox.information( null, "Qt Widgets Example",
				  "Could not load the file \"qt.png\", which\n"
				  + "contains an icon used...\n\n"
				  + "The text \"line 42\" will be substituted.",
				  TQMessageBox.Ok + TQMessageBox.Default );
    }

    // Create a label containing a TQMovie
    movie = new TQMovie( MOVIEFILENAME );
    movielabel = new TQLabel( central, "label0" );
    movie.connectStatus(this, SLOT("movieStatus(int)"));
    movie.connectUpdate(this, SLOT("movieUpdate(TQRect)"));
    movielabel.setFrameStyle( TQFrame.Box | TQFrame.Plain );
    movielabel.setMovie( movie );
    movielabel.setFixedSize( 128+movielabel.frameWidth()*2,
			      64+movielabel.frameWidth()*2 );
    grid.addWidget( movielabel, 0, 1, AlignCenter );
    TQToolTip.add( movielabel, "movie" );
    TQWhatsThis.add( movielabel, "This is a <b>TQLabel</b> "
		     + "that contains a TQMovie." );

    // Create a group of check boxes
    bg = new TQButtonGroup( central, "checkGroup" );
    bg.setTitle( "Check Boxes" );
    grid.addWidget( bg, 1, 0 );

    // Create a layout for the check boxes
    TQVBoxLayout vbox = new TQVBoxLayout(bg, 10);

    vbox.addSpacing( bg.fontMetrics().height() );

    cb[0] = new TQCheckBox( bg );
    cb[0].setText( "&Read" );
    vbox.addWidget( cb[0] );
    cb[1] = new TQCheckBox( bg );
    cb[1].setText( "&Write" );
    vbox.addWidget( cb[1] );
    cb[2] = new TQCheckBox( bg );
    cb[2].setText( "&Execute" );
    vbox.addWidget( cb[2] );

    connect( bg, SIGNAL("clicked(int)"), SLOT("checkBoxClicked(int)") );

    TQToolTip.add( cb[0], "check box 1" );
    TQToolTip.add( cb[1], "check box 2" );
    TQToolTip.add( cb[2], "check box 3" );

    // Create a group of radio buttons
    TQRadioButton rb;
    bg = new TQButtonGroup( central, "radioGroup" );
    bg.setTitle( "Radio buttons" );

    grid.addWidget( bg, 1, 1 );

    // Create a layout for the radio buttons
    vbox = new TQVBoxLayout(bg, 10);

    vbox.addSpacing( bg.fontMetrics().height() );
    rb = new TQRadioButton( bg );
    rb.setText( "&AM" );
    rb.setChecked( true );
    vbox.addWidget(rb);
    TQToolTip.add( rb, "radio button 1" );
    rb = new TQRadioButton( bg );
    rb.setText( "F&M" );
    vbox.addWidget(rb);
    TQToolTip.add( rb, "radio button 2" );
    rb = new TQRadioButton( bg );
    rb.setText( "&Short Wave" );
    vbox.addWidget(rb);

    connect( bg, SIGNAL("clicked(int)"), SLOT("radioButtonClicked(int)") );
    TQToolTip.add( rb, "radio button 3" );

    // Create a list box
    TQListBox lb = new TQListBox( central, "listBox" );
    for ( int i=0; i<100; i++ ) {		// fill list box
	String str = "line " + i;
	if ( i == 42 && pix )
	    lb.insertItem( pm );
	else
	    lb.insertItem( str );
    }
    grid.addMultiCellWidget( lb, 2, 4, 0, 0 );
    connect( lb, SIGNAL("selected(int)"), SLOT("listBoxItemSelected(int)") );
    TQToolTip.add( lb, "list box" );
//    new MyWhatsThis( lb );

    vbox = new TQVBoxLayout(8);
    grid.addLayout( vbox, 2, 1 );

    // Create a slider
    TQSlider sb = new TQSlider( 0, 300, 30, 100, TQSlider.Horizontal,
			       central, "Slider" );
    sb.setTickmarks( TQSlider.Below );
    sb.setTickInterval( 10 );
    sb.setFocusPolicy( TQWidget.TabFocus );
    vbox.addWidget( sb );

    connect( sb, SIGNAL("valueChanged(int)"), SLOT("sliderValueChanged(int)") );
    TQToolTip.add( sb, "slider" );
    TQWhatsThis.add( sb, "This is a <b>TQSlider</b>. "
		     + "The tick marks are optional."
		     + " This slider controls the speed of the movie." );
    // Create a combo box
    TQComboBox combo = new TQComboBox( false, central, "comboBox" );
    combo.insertItem( "darkBlue" );
    combo.insertItem( "darkRed" );
    combo.insertItem( "darkGreen" );
    combo.insertItem( "blue" );
    combo.insertItem( "red" );
    vbox.addWidget( combo );
    connect( combo, SIGNAL("activated(int)"),
	     this, SLOT("comboBoxItemActivated(int)") );
    TQToolTip.add( combo, "read-only combo box" );

    // Create an editable combo box
    TQComboBox edCombo = new TQComboBox( true, central, "edComboBox" );
    edCombo.insertItem( "Permutable" );
    edCombo.insertItem( "Malleable" );
    edCombo.insertItem( "Adaptable" );
    edCombo.insertItem( "Alterable" );
    edCombo.insertItem( "Inconstant" );
    vbox.addWidget( edCombo );
    connect( edCombo, SIGNAL("activated(String)"),
	     this, SLOT("edComboBoxItemActivated(String)") );
    TQToolTip.add( edCombo, "editable combo box" );

    edCombo.setAutoCompletion( true );

    vbox = new TQVBoxLayout(8);
    grid.addLayout( vbox, 2, 2 );

    // Create a spin box
    TQSpinBox spin = new TQSpinBox( 0, 10, 1, central, "spin" );
    spin.setSuffix(" mm");
    spin.setSpecialValueText( "Auto" );
    connect( spin, SIGNAL(" valueChanged(String)"),
	     SLOT(" spinBoxValueChanged(String)") );
    TQToolTip.add( spin, "spin box" );
    TQWhatsThis.add( spin, "This is a <b>TQSpinBox</b>. "
		     + "You can chose values in a given range "
		     + "either by using the arrow buttons "
		     + "or by typing them in." );
    vbox.addWidget( spin );

    vbox.addStretch( 1 );

    // Create a tabwidget that switches between multi line edits
    tabs = new TQTabWidget( central );
    //tabs.setTabPosition( TQTabWidget.Bottom );
    tabs.setMargin( 4 );
    grid.addMultiCellWidget( tabs, 3, 3, 1, 2 );
    TQMultiLineEdit mle = new TQMultiLineEdit( tabs, "multiLineEdit" );
    edit = mle;
    mle.setWordWrap( TQMultiLineEdit.WidgetWidth );
    mle.setText("This is a TQMultiLineEdit widget, "
	         + "useful for small multi-line "
		 + "input fields.");
    TQToolTip.add( mle, "multi line editor" );

    tabs.addTab( mle, "F&irst");

    mle = new TQMultiLineEdit( tabs, "multiLineEdit" );
    String mleText = "This is another TQMultiLineEdit widget.";
    mleText += "\n";
    mleText += "Japanese: ";
    mleText += (char) 0x6a38; // Kanji
    mleText += "\n";
    mleText += "Russian:";
    mleText += (char) 0x042e; // Cyrillic
    mleText += "\n";
    mleText += "Norwegian:";
    mleText += (char) 0x00d8; // Norwegian
    mleText += "\n";
    mleText += "Unicode (black square):";
    mleText += (char) 0x25A0; // BLACK SQUARE
    mleText += "\n";
    mle.setText( mleText );
    TQToolTip.add( mle, "second multi line editor" );
    tabs.addTab( mle, "Se&cond");


    // Create a single line edit
    TQLineEdit le = new TQLineEdit( central, "lineEdit" );


    grid.addMultiCellWidget( le, 4, 4, 1, 2 );
    connect( le, SIGNAL("textChanged(String)"),
	     SLOT("lineEditTextChanged(String)") );
    TQToolTip.add( le, "single line editor" );
    TQWhatsThis.add( le, "This is a <b>TQLineEdit</b>, you can enter a "
		     + "single line of text in it. "
		     + "It also it accepts text drops." );

    grid.setRowStretch(0,0);
    grid.setRowStretch(1,0);
    grid.setRowStretch(2,0);
    grid.setRowStretch(3,1);
    grid.setRowStretch(4,0);

    grid.setColStretch(0,1);
    grid.setColStretch(1,1);
    grid.setColStretch(2,1);


    TQSplitter split = new TQSplitter( Vertical, central, "splitter" );
    split.setOpaqueResize( true );
    topLayout.addWidget( split, 1 );
    TQListView lv = new MyListView( split );
    connect(lv, SIGNAL("selectionChanged()"),
	    this, SLOT(" selectionChanged()") );
    connect(lv, SIGNAL("selectionChanged(TQListViewItem)"),
	    this, SLOT(" selectionChanged(TQListViewItem)") );
    connect(lv, SIGNAL("clicked(TQListViewItem)"),
	    this, SLOT(" clicked(TQListViewItem)") );
    connect(lv, SIGNAL("mySelectionChanged(TQListViewItem)"),
	    this, SLOT(" mySelectionChanged(TQListViewItem)") );
    lv.addColumn( "One" );
    lv.addColumn( "Two" );
    lv.setAllColumnsShowFocus( true );

    TQListViewItem lvi=  new TQListViewItem( lv, "Text", "Text" );
    lvi=  new TQListViewItem( lv, "Text", "Other Text" );
    lvi=  new TQListViewItem( lv, "Text", "More Text" );
    lvi=  new TQListViewItem( lv, "Text", "Extra Text" );
    lvi.setOpen(true);
    new TQListViewItem( lvi, "SubText", "Additional Text" );
    lvi=  new TQListViewItem( lvi, "SubText", "Side Text" );
    lvi=  new TQListViewItem( lvi, "SubSubText", "Complimentary Text" );

    TQToolTip.add( lv, "list view" );
    TQWhatsThis.add( lv, "This is a <b>TQListView</b>, you can display lists "
		     + "(or outline lists) of multiple-column data in it." );

    lv = new TQListView( split );
    lv.addColumn( "Choices" );
    new TQCheckListItem( lv, "Onion", TQCheckListItem.CheckBox );
    new TQCheckListItem( lv, "Artichoke", TQCheckListItem.CheckBox );
    new TQCheckListItem( lv, "Pepper", TQCheckListItem.CheckBox );
    new TQCheckListItem( lv, "Habaneros", TQCheckListItem.CheckBox );
    new TQCheckListItem( lv, "Pineapple", TQCheckListItem.CheckBox );
    new TQCheckListItem( lv, "Ham", TQCheckListItem.CheckBox );
    new TQCheckListItem( lv, "Pepperoni", TQCheckListItem.CheckBox );
    new TQCheckListItem( lv, "Garlic", TQCheckListItem.CheckBox );


    TQCheckListItem lit = new TQCheckListItem( lv, "Cheese" );
    lit.setOpen( true );
    new TQCheckListItem( lit, "Cheddar", TQCheckListItem.RadioButton );
    new TQCheckListItem( lit, "Mozarella", TQCheckListItem.RadioButton );
    new TQCheckListItem( lit, "Jarlsberg", TQCheckListItem.RadioButton );

    TQToolTip.add( lv, "list view" );
    TQWhatsThis.add( lv, "This is also a <b>TQListView</b>, with "
		     + "interactive items." );

     TQTextView qmlv =  new TQTextView( "<hr><h1>TQTextView</h1>"
		      + "<p>Qt supports formatted rich text, such "
		      + "as the heading above, <em>emphasized</em> and "
		      + "<b>bold</b> text, via an XML subset.</p> "
		      + "<p>Style sheets are supported.</p>",
 				  "", split );
    qmlv.setFont(new TQFont("Charter",11));
    qmlv.setFrameStyle( TQFrame.WinPanel | TQFrame.Sunken );

    // Create an label and a message in the status bar
    // The message is updated when buttons are clicked etc.
    msg = new TQLabel( statusBar(), "message" );
    msg.setAlignment( AlignCenter );
    TQFont boldfont = new TQFont(); boldfont.setWeight(TQFont.Bold);
    msg.setFont( boldfont );
    statusBar().addWidget( msg, 4 );
    TQToolTip.add( msg, "Message area" );

    TQAccel a = new TQAccel( this );
    a.connectItem(  a.insertItem( new TQKeySequence(Key_F9) ),
		     this, SLOT(" showProperties()") );

    prog = new TQProgressBar( statusBar(), "progress" );
    prog.setTotalSteps( 100 );
    progress = 64;
    prog.setProgress( progress );
    statusBar().addWidget( prog , 1 );
    TQWhatsThis.add( prog, "This is a <b>TQProgressBar</b> "
		     + "You can use it to show that a lengthy "
		     + " process is progressing. "
		     + "In this program, nothing much seems to happen." );
    statusBar().message( "Welcome to Qt", 2000 );
}

void setStatus(String text)
{
    msg.setText(text);
}

void button1Clicked()
{
    msg.setText( "The push button was clicked" );
    prog.setProgress( ++progress );
}


void movieUpdate( TQRect r )
{
    // Uncomment this to test animated icons on your window manager
    //setIcon( movie.framePixmap() );
}

void movieStatus( int s )
{
    switch ( s ) {
      case TQMovie.SourceEmpty:
      case TQMovie.UnrecognizedFormat:
	{
	    TQPixmap pm = new TQPixmap("tt-logo.png");
	    movielabel.setPixmap(pm);
	    movielabel.setFixedSize(pm.size());
	}
      break;
      default:
	if ( movielabel.movie() != null )	 	// for flicker-free animation:
	    movielabel.setBackgroundMode( NoBackground );
    }
}


void popupSelected( int selectedId )
{
    if ( selectedId == plainStyleID ) {
	for ( int i = 0; i < textStylePopup.count(); i++ ) {
	    int id = textStylePopup.idAt( i );
	    textStylePopup.setItemChecked( id, false);
	}
    } else {
	textStylePopup.setItemChecked( selectedId, true );
    }
}

void checkBoxClicked( int id )
{
    String str;
    str = tr("Check box " + id + " clicked : ");
    String chk = (cb[0].isChecked() ? "r" : "-")
    + (cb[1].isChecked() ? "w" : "-")
    + (cb[2].isChecked() ? "x" : "-");
    str += chk;
    msg.setText( str );
}


void edComboBoxItemActivated( String text)
{
    String str = tr("Editable Combo Box set to ");
    str += text;
    msg.setText( str );
}


void radioButtonClicked( int id )
{
    msg.setText( tr("Radio button #" + id + " clicked") );
}


void listBoxItemSelected( int index )
{
    msg.setText( tr("List box item " + index +"  selected") );
}


void sliderValueChanged( int value )
{
    msg.setText( tr("Movie set to " + value + "% of normal speed") );
    movie.setSpeed( value );
}


void comboBoxItemActivated( int index )
{
    msg.setText( tr("Combo box item " + index + " activated") );
    switch ( index ) {
    default:
    case 0:
	TQApplication.setWinStyleHighlightColor( darkBlue() );
	break;
    case 1:
	TQApplication.setWinStyleHighlightColor( darkRed() );
	break;
    case 2:
	TQApplication.setWinStyleHighlightColor( darkGreen() );
	break;
    case 3:
	TQApplication.setWinStyleHighlightColor( blue() );
	break;
    case 4:
	TQApplication.setWinStyleHighlightColor( red() );
	break;
    }
}



void lineEditTextChanged( String newText )
{
    String str = "Line edit text: ";
    str += newText;
    if ( newText.length() == 1 ) {
	String u = " (U" + newText + "x" + newText + "x)";
	str += u;
    }
    msg.setText( str );
}


void spinBoxValueChanged( String valueText )
{
    String str = "Spin box value: " ;
    str += valueText;
    msg.setText( str );
}

//
// All application events are passed through this event filter.
// We're using it to display some information about a clicked
// widget (right mouse button + CTRL).
//

    
static boolean identify_now = true;

public boolean eventFilter( TQObject obj, TQEvent event )
{
    if ( event.type() == TQEvent.MouseButtonPress && event instanceof TQMouseEvent && identify_now ) {
	TQMouseEvent e = (TQMouseEvent)event;
	if ( e.button() == TQMouseEvent.RightButton &&
	     (e.state() & TQMouseEvent.ControlButton) != 0 ){
	    String str = "The clicked widget is a\n";
	    str += obj.className();
	    str += "\nThe widget's name is\n";
	    if ( !obj.name().equals("") )
		str += obj.name();
	    else
		str += "<no name>";
	    identify_now = false;		// don't do it in message box
	    TQMessageBox.information( (TQWidget)obj, "Identify Widget", str );
	    identify_now = true;		// allow it again
	}
    }
//    return super.eventFilter( obj, event ); // don't eat event
    return false; // don't eat event
}


void open()
{
    TQFileDialog.getOpenFileName( "", "Textfiles (.txt)", this );
}


void dummy()
{
    TQMessageBox.information( this, "Sorry",
			      "This function is not implemented" );
}

void selectionChanged()
{
    //tqDebug("selectionChanged");
}
void selectionChanged( TQListViewItem item)
{
    //tqDebug("selectionChanged %p", item );
}

void clicked( TQListViewItem item )
{
    //tqDebug("clicked %p", item );
}

void mySelectionChanged( TQListViewItem item )
{
    //tqDebug("mySelectionChanged %p", item );
}

void showProperties()
{
    if ( tqApp().focusWidget() == null )
	return;
    String output = "Properties for class '" + tqApp().focusWidget().className() + "'";
    int i = 0;
    while( i < (int) tqApp().focusWidget().metaObject().numProperties( true ) ) {
	TQMetaProperty p
	    = tqApp().focusWidget().metaObject().property( i, true );
	String tmp = "\n " + (++i) + ": " + p.name() 
	             + " (read-" + (p.writable() ? "write" : "only") + ", " + p.type() + ")";
	output += tmp;
    }
    tqDebug( output );
}
}
