/***************************************************************************
 *   Copyright Brian Ledbetter 2001-2003 <brian@shadowcom.net>             *
 *   Copyright Ravikiran Rajagopal 2003 <ravi@kde.org>                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License (version 2) as   *
 *   published by the Free Software Foundation. (The original KSplash/ML   *
 *   codebase (upto version 0.95.3) is BSD-licensed.)                      *
 *                                                                         *
 ***************************************************************************/

#ifndef __OBJKSTHEME_H__
#define __OBJKSTHEME_H__

#include <tdecmdlineargs.h>

#include <tqstring.h>
#include <tqstringlist.h>

class TDEConfig;
/**
 * @short Theme reader.
 * A Theme is read in from the file
 * <TDEDIR>/share/apps/ksplash/Themes/<theme>/Theme.rc
 * This controls the behavior, graphics, and appearance
 * of KSplash completely, and offers a friendlier way
 * of installing custom splash screens.
 */
class KDE_EXPORT ObjKsTheme : public QObject
{
  Q_OBJECT
public:
  explicit ObjKsTheme( const TQString& );
  virtual ~ObjKsTheme();

  void loadCmdLineArgs( TDECmdLineArgs * );

  TQString theme() const      { return( mActiveTheme ); }
  TQString themeEngine() const { return( mThemeEngine ); }
  TDEConfig *themeConfig() const { return( mThemeConfig ); }
  TQString themeDir() const   { return( mThemeDir );    }
  bool loColor() const       { return( mLoColor );     }
  bool testing() const       { return( mTesting );     }
  bool managedMode() const   { return( mManagedMode ); }
  TQString icon( int i ) { return (m_icons[i-1].isNull()?(TQString::null):m_icons[i-1]); }
  TQString text( int i ) { return (m_text[i-1].isNull()?(TQString::null):m_text[i-1]);   }
  TQString locateThemeData( const TQString &resource );
  int xineramaScreen() const { return mXineramaScreen; }

protected:
  bool loadThemeRc( const TQString&, bool );
  bool loadLocalConfig( const TQString&, bool );
  bool loadTDEConfig( TDEConfig *, const TQString&, bool );

private:
  TQString mActiveTheme, mThemeDir;
  TDEConfig *mThemeConfig;

  int mXineramaScreen;
  bool mLoColor, mTesting, mManagedMode;
  TQString mThemeEngine;
  TQString mThemePrefix;

  TQStringList m_icons, m_text;

  class ObjKsThemePrivate;
  ObjKsThemePrivate *d;
};

#endif
