/* ****************************************************************************
  This file is part of KBabel

  Copyright (C) 2000 by Matthias Kiefer
                            <matthias.kiefer@gmx.de>
		2003 by Stanislav Visnovsky
			    <visnovsky@kde.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
  MA  02110-1301, USA.

  In addition, as a special exception, the copyright holders give
  permission to link the code of this program with any edition of
  the TQt library by Trolltech AS, Norway (or with modified versions
  of TQt that use the same license as TQt), and distribute linked
  combinations including the two.  You must obey the GNU General
  Public License in all respects for all of the code used other than  
  TQt. If you modify this file, you may extend this exception to
  your version of the file, but you are not obligated to do so.  If
  you do not wish to do so, delete this exception statement from
  your version.
		  
**************************************************************************** */
#include <dcopclient.h>
#include <tdeaboutdata.h>
#include <tdecmdlineargs.h>
#include <kcursor.h>
#include <tdelocale.h>
#include <tdeapplication.h>
#include <twin.h>

#include <tqtimer.h>

#include "kbabeldict.h"
#include "kbabelsplash.h"
#include <version.h>

class KBabelDictApplication : public TDEApplication
{
public:
    KBabelDictApplication();
    ~KBabelDictApplication();

private:
    KBabelDict *topLevel;
};

KBabelDictApplication::KBabelDictApplication()
    : TDEApplication()
    , topLevel(0)
{
    TDECmdLineArgs *args = TDECmdLineArgs::parsedArgs();
    
    TQTimer timer;
    TQWidget *splash=0;
    bool showSplash=args->isSet("splash");
    if(showSplash)
    {
        timer.start(2000,true);
        TDEApplication::setOverrideCursor(KCursor::waitCursor());
        splash = new KBabelSplash();
	splash->show();
    }
	
    topLevel = new KBabelDict();

    while(timer.isActive()) // let the user admire the splash screen ;-)
        processEvents();

	setTopWidget(topLevel);
    topLevel->show();

    if(KBabelSplash::instance)
    {
        delete KBabelSplash::instance;
    }
    if(showSplash)
    {
        TDEApplication::restoreOverrideCursor();
    }

    TQObject::connect( topLevel, TQT_SIGNAL( destroyed() ),
	     this, TQT_SLOT( quit() ) );
}

KBabelDictApplication::~KBabelDictApplication()
{
    delete(topLevel);
}

static TDECmdLineOptions options[] =
{
   {"nosplash",I18N_NOOP("Disable splashscreen at startup"),0},
   TDECmdLineLastOption
};


int main(int argc, char **argv)
{
    TDELocale::setMainCatalogue("kbabel");
    
    TDEAboutData about("kbabeldict",I18N_NOOP("KBabel - Dictionary"),VERSION,
       I18N_NOOP("A dictionary for translators"),TDEAboutData::License_GPL,
       I18N_NOOP("(c) 2000,2001,2002,2003 The KBabeldict developers"),0,"http://kbabel.kde.org");

    about.addAuthor("Matthias Kiefer",I18N_NOOP("Original author"),"kiefer@kde.org");
    about.addAuthor("Stanislav Visnovsky",I18N_NOOP("Current maintainer"),"visnovsky@kde.org");

    about.setTranslator( I18N_NOOP("_: NAME OF TRANSLATORS\nYour names")
	, I18N_NOOP("_: EMAIL OF TRANSLATORS\nYour emails"));

    // Initialize command line args
    TDECmdLineArgs::init(argc, argv, &about);

    // Tell which options are supported
    TDECmdLineArgs::addCmdLineOptions( options );

    // Add options from other components
    TDEApplication::addCmdLineOptions();
    
    KBabelDictApplication app;

    return app.exec();
}
