#
# spec file for package libtdeldap (version R14)
#
# Copyright (c) 2014 Trinity Desktop Environment
#
# All modifications and additions to the file contributed by third parties
# remain the property of their copyright owners, unless otherwise agreed
# upon. The license for this file, and modifications and additions to the
# file, is the same license as for the pristine package itself (unless the
# license for the pristine package is not an Open Source License, in which
# case the license is the MIT License). An "Open Source License" is a
# license that conforms to the Open Source Definition (Version 1.9)
# published by the Open Source Initiative.
#
# Please submit bugfixes or comments via http://www.trinitydesktop.org/
#

# BUILD WARNING:
#  Remove qt-devel and qt3-devel and any kde*-devel on your system !
#  Having KDE libraries may cause FTBFS here !

# TDE variables
%define tde_epoch 2
%if "%{?tde_version}" == ""
%define tde_version 14.0.7
%endif
%define tde_pkg libtdeldap
%define tde_prefix /opt/trinity
%define tde_bindir %{tde_prefix}/bin
%define tde_datadir %{tde_prefix}/share
%define tde_docdir %{tde_datadir}/doc
%define tde_includedir %{tde_prefix}/include
%define tde_libdir %{tde_prefix}/%{_lib}
%define tde_tdeappdir %{tde_datadir}/applications/tde
%define tde_tdedocdir %{tde_docdir}/tde
%define tde_tdeincludedir %{tde_includedir}/tde
%define tde_tdelibdir %{tde_libdir}/trinity


Name:		trinity-%{tde_pkg}
Epoch:		%{tde_epoch}
Version:	0.5
Release:	%{?tde_version}_%{?!preversion:1}%{?preversion:0_%{preversion}}%{?dist}
Summary:	LDAP interface library for TDE
Group:		System/Libraries
URL:		http://www.trinitydesktop.org/

%if 0%{?suse_version}
License:	GPL-2.0+
%else
License:	GPLv2+
%endif

#Vendor:		Trinity Desktop
#Packager:	Francois Andriot <francois.andriot@free.fr>

Prefix:			%{tde_prefix}
BuildRoot:		%{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)

Source0:	%{name}-%{tde_version}%{?preversion:~%{preversion}}.tar.gz

BuildRequires:	trinity-tdelibs-devel >= %{tde_version}

BuildRequires:	desktop-file-utils
BuildRequires:	gettext
BuildRequires:	gcc-c++

# AUTOTOOLS
BuildRequires: automake autoconf libtool
%if 0%{?mgaversion} || 0%{?mdkversion}
BuildRequires:	%{_lib}ltdl-devel
%endif
%if 0%{?fedora} || 0%{?rhel} >= 5 || 0%{?suse_version} >= 1220
BuildRequires:	libtool-ltdl-devel
%endif

# SASL support
%if 0%{?mageia} || 0%{?mandriva} || 0%{?pclinuxos}
BuildRequires:	%{_lib}sasl2-devel
%endif
%if 0%{?suse_version}
BuildRequires:	cyrus-sasl-devel
%endif

# OPENLDAP support
%if 0%{?rhel} >= 6 || 0%{?fedora} || 0%{?mdkversion} || 0%{?mgaversion}
BuildRequires:	openldap-devel
%endif
%if 0%{?suse_version}
BuildRequires:	openldap2-devel
%endif
%if 0%{?rhel} == 5
BuildRequires:	openldap24-libs-devel
%endif

# HEIMDAL support
#%if 0%{?rhel} >= 5 || 0%{?fedora} || 0%{?mdkversion} || 0%{?mgaversion}
#BuildRequires:	heimdal-devel
#%endif
#%if 0%{?suse_version}
#BuildRequires:	libheimdal-devel
#%endif

# UDEV support
%if 0%{?fedora} || 0%{?mdkversion} || 0%{?mgaversion} || 0%{?suse_version} || 0%{?rhel} >= 6
%define with_tdehwlib 1
BuildRequires:	libudev-devel
%endif

# LIBCOM_ERR support
%if 0%{?fedora} || 0%{?suse_version} || 0%{?rhel} >= 6
BuildRequires:	libcom_err-devel
%endif
%if 0%{?mdkversion} || 0%{?mgaversion}
BuildRequires:	%{_lib}ext2fs-devel
%endif

# ACL support
BuildRequires:	libacl-devel

# IDN support
BuildRequires:	libidn-devel

# OPENSSL support
BuildRequires:	openssl-devel


%description
LDAP interface library for TDE management modules.

%files
%defattr(-,root,root,-)
%{tde_libdir}/libtdeldap.so.1
%{tde_libdir}/libtdeldap.so.1.0.0

##########

%package devel
Group:		Development/Libraries/Other
Summary:	Trinity image viewer
Requires:	%{name} = %{?epoch:%{epoch}:}%{version}-%{release}

%description devel
LDAP interface library for TDE management modules.

libtdeldap-trinity-dev contains development files and documentation.

%files devel
%defattr(-,root,root,-)
%{tde_tdeincludedir}/ldappasswddlg.h
%{tde_tdeincludedir}/libtdeldap.h
%{tde_libdir}/libtdeldap.la
%{tde_libdir}/libtdeldap.so

##########

%if 0%{?pclinuxos} || 0%{?suse_version} && 0%{?opensuse_bs} == 0
%debug_package
%endif

##########

%prep
%setup -q -n %{name}-%{tde_version}%{?preversion:~%{preversion}}

%__cp "/usr/share/aclocal/libtool.m4" "admin/libtool.m4.in"
%__cp "/usr/share/libtool/"*"/ltmain.sh" "admin/ltmain.sh" || %__cp "/usr/share/libtool/ltmain.sh" "admin/ltmain.sh"
%__make -f "admin/Makefile.common"


%build
unset QTDIR QTINC QTLIB
export PATH="%{tde_bindir}:${PATH}"

extra_includes="%{_includedir}"
extra_libs="%{_libdir}"

if [ -d "%{_includedir}/openldap24" ]; then
  extra_includes="%{_includedir}/openldap24:${extra_includes}"
  extra_libs="%{_libdir}/openldap24:${extra_libs}"
fi

#if [ -d "%{_includedir}/heimdal" ]; then
#  extra_includes="%{_includedir}/heimdal:${extra_includes}"
#  extra_libs="%{_libdir}/heimdal:${extra_libs}"
#fi

%configure \
  --prefix=%{tde_prefix} \
  --exec-prefix=%{tde_prefix} \
  --bindir=%{tde_bindir} \
  --datadir=%{tde_datadir} \
  --libdir=%{tde_libdir} \
  --includedir=%{tde_tdeincludedir} \
  \
  --disable-dependency-tracking \
  --disable-debug \
  --enable-new-ldflags \
  --enable-final \
  --enable-closure \
  --enable-rpath \
  --disable-gcc-hidden-visibility \
  \
  --with-extra-includes=${extra_includes} \
  --with-extra-libs=${extra_libs} \

%__make %{?_smp_mflags}


%install
export PATH="%{tde_bindir}:${PATH}"
%__rm -rf %{buildroot}
%__make install DESTDIR=%{buildroot}


%clean
%__rm -rf %{buildroot}


%changelog
