#!/bin/bash

VERSION="$1" # E.g: '42.3'

if [ "${VERSION}" = "tumbleweed" ]; then
  URL="http://download.opensuse.org/tumbleweed"
  NAME="opensuse32/tumbleweed"
else
  URL="http://download.opensuse.org/distribution/leap/${VERSION}"
  NAME="opensuse32/leap"
fi

IMAGE="${NAME}:${VERSION}"
INSTALLROOT="/dev/shm/${IMAGE}"

sudo rm -rf "${INSTALLROOT}"
sudo mkdir -p "${INSTALLROOT}"

sudo zypper --root "${INSTALLROOT}" \
  ar "${URL}/repo/oss/" "oss"
sudo zypper --root "${INSTALLROOT}" \
  ar "${URL}/repo/non-oss/" "non-oss"

if [ "${VERSION}" != "tumbleweed" ]; then
  sudo zypper --root "${INSTALLROOT}" \
    ar "http://download.opensuse.org/update/leap/${VERSION}/oss/" "update-oss"
  sudo zypper --root "${INSTALLROOT}" \
    ar "http://download.opensuse.org/update/leap/${VERSION}/non-oss/" "update-non-oss"
fi
setarch i686 sudo zypper --root "${INSTALLROOT}" \
  --gpg-auto-import-keys ref
setarch i686 sudo zypper --root "${INSTALLROOT}" \
  install -y bash vim zypper openSUSE-release

sudo tar -C "${INSTALLROOT}" -c . >"${IMAGE}.tar"
sudo rm -rf "${INSTALLROOT}"

docker rmi -f "${IMAGE}"
docker import "${IMAGE}.tar" "${IMAGE}"
