/**

  	 Copyright (C) 2003-2005 Mickael Marchand <marchand@kde.org>

	 This program is free software; you can redistribute it and/or
	 modify it under the terms of the GNU General Public
	 License as published by the Free Software Foundation; either
	 version 2 of the License, or (at your option) any later version.

	 This program is distributed in the hope that it will be useful,
	 but WITHOUT ANY WARRANTY; without even the implied warranty of
	 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
	 General Public License for more details.

	 You should have received a copy of the GNU General Public License
	 along with this program; see the file COPYING.  If not, write to
	 the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
	 Boston, MA 02110-1301, USA.
	 */

#ifndef __SUBVERSION_CORE_H__
#define __SUBVERSION_CORE_H__

#include <tqobject.h>
#include <tqwidget.h>
#include <tdeio/job.h>
#include <kurl.h>
#include <ktempdir.h>
#include "subversion_fileinfo.h"
#include "subversion_global.h"

class KDevProject;
class subversionPart;
class subversionWidget;
class TDEApplication;
class SvnBlameHolder;
class SvnLogHolder;
class SvnLogViewWidget;

// class subversionCore : public TQObject, public DCOPObject
class subversionCore : public TQObject {
  Q_OBJECT
  
//   K_DCOP

public:

  subversionCore(subversionPart *part);
  ~subversionCore();
	subversionWidget *processWidget() const;
// 	SvnLogViewWidget *processWidget() const;
	void update( const KURL::List&);
	void commit( const KURL::List&, bool recurse, bool keeplocks );
	void svnLog( const KURL::List& list,
			int revstart, TQString revKindStart, int revend, TQString revKindEnd, 
			bool discorverChangedPath, bool strictNodeHistory );
	void blame( const KURL &url, SvnGlobal::UrlMode mode, int revstart, TQString revKindStart, int revend, TQString revKindEnd );
	void add( const KURL::List&);
	void del( const KURL::List&);
	void diff( const KURL::List&, const TQString& where);
	void diffAsync( const KURL &pathOrUrl1, const KURL &pathOrUrl2,
					int rev1, TQString revKind1, int rev2, TQString revKind2,
					bool recurse, bool pegdiff = false );
	void revert( const KURL::List&);
	void resolve( const KURL::List&);
	void checkout();
	void switchTree( const KURL &path, const KURL &repositUrl,
					 int revNum, const TQString &revKind, bool recurse );
	void switchRelocate( const KURL &path, const KURL &currentUrl, const KURL &newUrl, bool recurse );
	void svnCopy( const KURL &src, int srcRev, const TQString &srcRevKind, const KURL &dest );
	void merge( const KURL &src1, int rev1, TQString revKind1, const KURL &src2, int rev2, TQString revKind2, const KURL &wc_path,
				   bool recurse, bool ignore_ancestry, bool force, bool dry_run );
    // This is blocking function. But the GUI is not blocked.
    // Information will be pulled solely from the working copy.Thus no network connections will be made.
    // Parameter holderMap is the map to be filled out by this method. Callers should preallocate this object.
    // Return true on success. Otherwise return false.
    bool clientInfo( KURL path_or_url, bool recurse, TQMap< KURL, SvnGlobal::SvnInfoHolder> &holderMap );
	void createNewProject( const TQString& dirName, const KURL& importURL, bool init );
    KDevVCSFileInfoProvider *fileInfoProvider() const;
	
	void initProcessDlg( TDEIO::Job *job, const TQString &src, const TQString &dest );
// k_dcop:
// 	void notification( const TQString&, int,int, const TQString&, int,int ,long int, const TQString& );

private slots:
	void slotEndCheckout( TDEIO::Job * job );
	void slotResult( TDEIO::Job * job );
	void slotLogResult( TDEIO::Job * job );
	void slotBlameResult( TDEIO::Job * job );
	void slotDiffResult( TDEIO::Job * job );

signals:
	void checkoutFinished( TQString dir );

private:
	TQGuardedPtr<subversionWidget> m_widget;
	subversionPart *m_part;
	TQString wcPath;
	SVNFileInfoProvider *m_fileInfoProvider;
	TQStringList diffresult; //for diff commands ;)
	// be nice about tmp diff files: delete all of them when exiting.
	KTempDir* diffTmpDir;

};

#endif
