/***************************************************************************
 *   Copyright (C) 2003 Alexander Dymo                                     *
 *   cloudtemple@mksat.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#ifndef __KDEVPART_PASCALSUPPORT_H__
#define __KDEVPART_PASCALSUPPORT_H__

#include <tqguardedptr.h>
#include "kdevlanguagesupport.h"

class PascalSupportWidget;
class KDialogBase;
class TQPopupMenu;
class Context;
class PascalSupportPartData;

class PascalSupportPart : public KDevLanguageSupport
{
    Q_OBJECT
  
public:
    PascalSupportPart(TQObject *parent, const char *name, const TQStringList &);
    ~PascalSupportPart();

    virtual Features features();
    virtual KMimeType::List mimeTypes();

    virtual TQString formatTag( const Tag& tag );
    virtual TQString formatModelItem( const CodeModelItem *item, bool shortDescription=false );
    
private slots:
    void projectOpened();
    void projectClosed();
    void savedFile(const KURL &fileName);
    void configWidget(KDialogBase *dlg);
    void projectConfigWidget(KDialogBase *dlg);
    void contextMenu(TQPopupMenu *popup, const Context *context);

    void addedFilesToProject(const TQStringList &fileList);
    void removedFilesFromProject(const TQStringList &fileList);
    void slotProjectCompiled();

    void initialParse();

private:
    void maybeParse(const TQString &fileName);
    void parse(const TQString &fileName);

    TQGuardedPtr<PascalSupportWidget> m_widget;

    bool m_projectClosed;
    TQStringList m_projectFileList;

    PascalSupportPartData* d;

};

#endif
