/***************************************************************************
*   Copyright (C) 2003 by Jonas B. Jacobi                                 *
*   j.jacobi@gmx.de                                                       *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/
#ifndef DOXYDOC_H
#define DOXYDOC_H

#include <tqstring.h>
#include <tqdom.h>
#include <tqdir.h>
#include <tqfile.h>
#include <list>

/**
This class is used for getting the description on functions, stored in xml files, which are created by Doxygen
@author Jonas B. Jacobi
@version 0.1
*/
class DoxyDoc
{
public:
	/**
		Constructs a new DoxyDoc object.
		@param dir all directories, which should be searched for files containing the Doxygen-documentation.
	*/
	DoxyDoc( const TQStringList& dir );
	~DoxyDoc()
	{}
	;
	/**
		Get the documentation referring to a special function, therefor most parts of the functions signature have to be provided
		@param scope Scope of the function (e.g. name of class, it is member of, namespace etc ...)
		@param name Name of the function(just the name, no '(' etc. )
		@param type Return-type of the function
		@param arguments String containing the arguments of the function, separated by commas and _without_ the argument names
	*/
	TQString functionDescription( const TQString& scope, const TQString& name, const TQString& type, const TQString& arguments );
	/*not implemented yet, maybe later, if they are useful
	TQString classDescription();
	TQString enumDescription();
	TQString namespaceDescription();
	TQString memberVarDescription();
	*/
private:
	static void formatType( TQString& type );
	std::list<TQDir> m_dirs;
	//used for temporary storing/performance reasons
	TQFile m_file;
	TQDomNodeList m_list;
};

#endif 
// kate: indent-mode csands; tab-width 4;

