/*
  TDevelop Autotools Support
  Copyright (c) 2001-2002 by Bernd Gehrmann <bernd@kdevelop.org>
  Copyright (c) 2002 by Victor Roeder <victor_roeder@gmx.de>
  Copyright (c) 2005 by Matt Rogers <mattr@kde.org>

***************************************************************************
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
***************************************************************************
*/

#ifndef _AUTOPROJECTWIDGET_H_
#define _AUTOPROJECTWIDGET_H_

#include <tqdict.h>
#include <tqlistview.h>
#include <tqmap.h>
#include <tqvbox.h>
#include <tqhbox.h>
#include <tqlayout.h>
#include <tqtoolbutton.h>
#include <kiconloader.h>
#include <tdelocale.h>

#include "domutil.h"
#include "makefilehandler.h"

class AutoProjectPart;
class AutoSubprojectView;
class AutoDetailsView;
class SubprojectItem;
class TargetItem;
class FileItem;
class TDEAction;
class TQDomElement;
class TQToolButton;
class TQStringList;
class TQFocusEvent;
class TDEListViewItem;
class TQListViewItem;
class MakefileHandler;

class AutoProjectWidget : public TQVBox
{
	Q_OBJECT
  
	friend class RemoveFileDialog;
	friend class TargetOptionsDialog;  // to access projectDom() via m_part->projectDom()
public:
	AutoProjectWidget( AutoProjectPart *part, bool kde );
	~AutoProjectWidget();

	void openProject( const TQString &dirName );
	void closeProject();

	/**
	* A list of the (relative) names of all subprojects (== subdirectories)
	*/
	TQStringList allSubprojects();
	/**
	 * A list of all Subproject items in the overview TDEListView
	 */
	TQPtrList <SubprojectItem> allSubprojectItems();
	/**
	* A list of the (relative) names of all libraries
	*/
	TQStringList allLibraries();
	/**
	* A list of all files that belong to the project
	**/
	TQStringList allFiles();
	/**
	* The top level directory of the project.
	**/
	TQString projectDirectory() const;
	/**
	* The directory of the currently shown subproject.
	*/
	TQString subprojectDirectory();
	/**
	* Are we in KDE mode?
	*/
	bool kdeMode() const
	{
		return m_kdeMode;
	}

	/**
	* Sets the given target active. The argument is given
	* relative to the project directory.
	*/
	void setActiveTarget( const TQString &targetPath );
	/**
	* Returns the active target as path relative to
	* the project directory.
	*/
	TQString activeDirectory();

	/**
	* Adds a file to the active target.
	* If the file does not contain a "/" character, it is added
	* to the active target.
	* If it does contain "/" character(s), ... @todo .. add to appropriate target
	*/
	void addFiles( const TQStringList &list );
	/**
	* Removes the file fileName from the directory directory.
	* (not implemented currently)
	*/
	void removeFiles( const TQStringList &list );

	/**
	* Returns the currently selected target. Returns 0 if
	* no target is selected.
	*/
	TargetItem *selectedTarget();

	/**
	* Returns the currently selected file. Returns 0 if
	* no file is selected.
	*/
	FileItem *selectedFile();

	/**
	* Returns the currently selected subproject (directory with Makefile.am). Returns 0 if
	* no subproject is selected.
	*/
	SubprojectItem* selectedSubproject();

	/**
	* Creates a TargetItem instance without a parent item.
	*/
	TargetItem *createTargetItem( const TQString &name,
	                              const TQString &prefix, const TQString &primary,
	                              bool take = true );
	/**
	* Creates a FileItem instance without a parent item.
	*/
	FileItem *createFileItem( const TQString &name, SubprojectItem *subproject );

	/**
	 * Returns the Subproject that contains the Active Target. The Active Target is a special target
	 * to which e.g. all files are added to.
	 */
	SubprojectItem* activeSubproject ();
	void setActiveSubproject( SubprojectItem* spitem );

	/**
	 * Returns the Active Target. The Active Target is a special target
	 * to which e.g. all files are added to.
	 */
	TargetItem* activeTarget();

	/**
	 * Returns the sub project item, if any, for a given path. The path supplied can be either
	 * absolute, or relative to the project directory. If no subproject item is found for the
	 * path, null is returned.
	 */
	SubprojectItem* subprojectItemForPath( const TQString & path, bool pathIsAbsolute = false );

	/**
	 * Returns the projectdir-relative path for a target item
	 */
	TQString pathForTarget( const TargetItem *item ) const;

	/**
	 * Adds file fileName to target titem in subproject spitem
	 */
	void addToTarget( const TQString & fileName, SubprojectItem* spitem, TargetItem* titem );

	/**
	* Restores the last settings of the AutoProjectWidget
	*/
	void restoreSession ( const TQDomElement* el );

	/**
	 * Saves the latest changes of the AutoProjectWidget to the session file.
	 */
	void saveSession ( TQDomElement* el );

	AutoSubprojectView* getSubprojectView ();
	AutoDetailsView* getDetailsView ();


	void emitAddedFile ( const TQString& name );
	void emitAddedFiles( const TQStringList &fileList );
	void emitRemovedFile ( const TQString& name );
	void emitRemovedFiles( const TQStringList &fileList );

	void parse( SubprojectItem *item );

	enum AutoProjectView { SubprojectView, DetailsView };
	void setLastFocusedView( AutoProjectView view );

	MakefileHandler* makefileHandler();

public slots:
	void slotOverviewSelectionChanged( TQListViewItem *item );

protected:
	void initOverview ( TQWidget* parent );
	void initDetailview ( TQWidget* parent );
	void initActions ();

	virtual void focusInEvent( TQFocusEvent *e );

private:

	AutoSubprojectView* m_subprojectView;
	AutoDetailsView* m_detailView;

	bool m_kdeMode;
	AutoProjectPart *m_part;
	SubprojectItem *m_activeSubproject;
	TargetItem *m_activeTarget;
	TargetItem *m_choosenTarget;
	SubprojectItem *m_shownSubproject;

	AutoProjectView m_lastFocusedView;

	MakefileHandler *m_makefileHandler;
};

#endif
// kate: indent-mode csands; tab-width 4;
