/*
    cwloadingwidget.h  -  Widget to be shown while loading data

    begin       : sun march 18 17:12:24 CET 2001
    copyright   : (c) 2001 by Martijn Klingens
    email       : klingens@kde.org

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/

#ifndef KBBMAINWINDOW_CWLOADINGWIDGET_H
#define KBBMAINWINDOW_CWLOADINGWIDGET_H

#include <tqlabel.h>
#include <tqframe.h>

class TQPixmap;
class KPixmap;

namespace KBugBusterMainWindow
{

/**
 * @author Martijn Klingens
 */
class CWLoadingWidget : public TQFrame
{
    Q_OBJECT
  

public:
    /**
     * Use WidgetMode to specify the layout for the background images
     * TopFrame loads and uses the logo and horizontal bars,
     * BottomFrame loads the tools and the translucent block.
     */
    enum WidgetMode { TopFrame = 0, BottomFrame };
    
    CWLoadingWidget( WidgetMode mode = TopFrame, TQWidget* parent = 0,
                     const char* name = 0 );
    CWLoadingWidget( const TQString &text, WidgetMode mode = TopFrame,
                     TQWidget* parent = 0, const char* name = 0 );
    ~CWLoadingWidget();

    TQString text() const { return m_text; }
    void setText( const TQString &text );
    
protected:
    virtual void mouseReleaseEvent( TQMouseEvent * );
    virtual void drawContents( TQPainter *p );
    virtual void resizeEvent( TQResizeEvent * );

signals:
    void clicked();
    
private:
    void init( WidgetMode mode );
    void updatePixmap();

    TQString m_text;
    WidgetMode m_mode;

    // Pixmaps used
    TQPixmap *m_toolsPixmap;
    TQPixmap *m_logoPixmap;
    TQPixmap *m_topRightPixmap;
    TQPixmap *m_barsPixmap;

    // For performance reasons we apply the KPixmapEffect only once
    KPixmap *m_toolsPixmapEffect;
    
    TQPixmap *m_buffer;
    
};

}   // namespace

#endif // KBBMAINWINDOW_CWLOADINGWIDGET_H

/* vim: set et ts=4 softtabstop=4 sw=4: */

