/*
    This file is part of tdepim.

    Copyright (c) 2004 Cornelius Schumacher <schumacher@kde.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/
#ifndef TDEABC_RESOURCEGROUPWISECONFIG_H
#define TDEABC_RESOURCEGROUPWISECONFIG_H

#include "soap/groupwiseserver.h"

#include <tderesources/configwidget.h>
#include <tdepimmacros.h>

#include <tqmap.h>

class KComboBox;
class KLineEdit;
class TDEListView;
class KURLRequester;

namespace TDEABC {

class ResourceGroupwise;

class KDE_EXPORT ResourceGroupwiseConfig : public KRES::ConfigWidget
{ 
  Q_OBJECT
  

  public:
    ResourceGroupwiseConfig( TQWidget* parent = 0, const char* name = 0 );

  public slots:
    void loadSettings( KRES::Resource* );
    void saveSettings( KRES::Resource* );

  protected slots:
    void updateAddressBookList();

  private:
    void updateAddressBookView();
    void saveAddressBookSettings();
    void loadAddressBookSettings();
    void saveServerSettings( ResourceGroupwise *resource );

    KURLRequester *mURL;
    KLineEdit *mUser;
    KLineEdit *mPassword;

    TDEListView *mAddressBookView;
    KComboBox *mAddressBookBox;

    TQStringList mWriteAddressBookIds;
    TQStringList mReadAddressBookIds;
    ResourceGroupwise *mResource;
};

}

#endif
