/*
  The mediastreamer library aims at providing modular media processing and I/O
	for linphone, but also for any telephony application.
  Copyright (C) 2001  Simon MORLAT simon.morlat@linphone.org
  										
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

  JACK support
  Copyright (C) 2004  Tobias Gehrig tobias@gehrig.tk
*/

#ifndef JACK_CARD_H
#define JACK_CARD_H

#include <config.h>

#ifdef __JACK_ENABLED__

#include "sndcard.h"

#include <jack/jack.h>
#include <jack/ringbuffer.h>

#include <samplerate.h>

typedef jack_default_audio_sample_t sample_t;

typedef struct {
  jack_port_t *port;
  const char **phys_ports;
  float level;
  jack_ringbuffer_t *buffer;
  gint channels;
  gint rate;
  SRC_STATE* src_state;
  SRC_DATA data;
  size_t frames;
  gboolean can_process;
  gboolean open;
  gboolean init;
} jackcard_mode_t;

struct _JackCard
{
  SndCard parent;

  jack_client_t *client;
  gboolean jack_running;
  gboolean jack_active;
  float level;
  jack_nframes_t buffer_size;
  gint sample_size;
  gint frame_size;
  gint rate;
  gboolean can_process;
  gboolean clear;

  jackcard_mode_t read, write;
};

typedef struct _JackCard JackCard;

SndCard * jack_card_new(jack_client_t *client);

gint jack_card_manager_init(SndCardManager *m, gint index);

#endif

#endif
