#ifndef COMMON_MISC_UI_H
#define COMMON_MISC_UI_H

#include <tqcanvas.h>
#include <tqptrvector.h>
#include <tqhbox.h>

#include <kgameprogress.h>
#include "lib/libksirtet_export.h"

#include "base/board.h"

/*****************************************************************************/
class LIBKSIRTET_EXPORT ShowNextPiece : public FixedCanvasView
{
 Q_OBJECT
  
 public:
    ShowNextPiece(BaseBoard *, TQWidget *parent);
};

/*****************************************************************************/
class LIBKSIRTET_EXPORT Shadow : public TQWidget
{
 Q_OBJECT
  
 public:
    Shadow(BaseBoard *, TQWidget *parent);

    virtual TQSize sizeHint() const;
    virtual TQSizePolicy sizePolicy() const;
    void setDisplay(bool show);

 private:
    int              _xOffset;
    const BaseBoard *_board;
    bool             _show;

    void paintEvent(TQPaintEvent *);
};

/*****************************************************************************/
class Led;

class LIBKSIRTET_EXPORT GiftPool : public TQHBox
{
 Q_OBJECT
  
 public:
    GiftPool(TQWidget *parent);

    virtual TQSize sizeHint() const;
    virtual TQSizePolicy sizePolicy() const;

    void reset();
	void put(uint);
	uint take();
	bool pending() const { return ready; }

 private slots:
    void timeout() { ready = true; }

 private:
	TQPtrVector<Led> leds;
	uint         _timeout, nb;
	bool         ready;
};


/*****************************************************************************/
class LIBKSIRTET_EXPORT PlayerProgress : public KGameProgress
{
  Q_OBJECT
  
public:
  PlayerProgress(BaseBoard *board, TQWidget *parent = 0, const char *name = 0);
  
  virtual TQSize sizeHint() const;
  virtual TQSizePolicy sizePolicy() const;
  
private:
  BaseBoard *_board;
};

#endif
