#ifndef KOLFTEST_H
#define KOLFTEST_H

#include <tqcanvas.h>
#include <tqobject.h>

#include <klibloader.h>

#include <kolf/canvasitem.h>
#include <kolf/object.h>

class TDEConfig;

class TestFactory : KLibFactory {
    Q_OBJECT
    

public:
    TQObject *createObject(TQObject *, const char *, const char *, const TQStringList & = TQStringList());
};

class Test : public TQCanvasEllipse, public CanvasItem
{
public:
	Test(TQCanvas *canvas);

	virtual Config *config(TQWidget *parent);
	virtual void save(TDEConfig *cfg);
	virtual void load(TDEConfig *cfg);

	virtual void advance(int phase);

	int switchEvery() const { return m_switchEvery / 2; }
	void setSwitchEvery(int news) { m_switchEvery = news * 2; }

private:
	int count;
	int m_switchEvery;
};

class TestConfig : public Config
{
	Q_OBJECT
  

public:
	TestConfig(Test *test, TQWidget *parent);

private slots:
	void switchEveryChanged(int news);

private:
	Test *m_test;
};

class TestObj : public Object
{
public:
	TestObj() { m_name = i18n("Flash"); m__name = "flash"; m_author = "Jason Katz-Brown"; }
	virtual TQCanvasItem *newObject(TQCanvas *canvas) { return new Test(canvas); }
};

#endif
