// -*- c++ -*-

/*
 *  Copyright (C) 2003, Richard J. Moore <rich@kde.org>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this library; see the file COPYING.LIB.  If not, write to
 *  the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 */

#ifndef KJSEMBED_JSOBJECTEVENTPROXY_H
#define KJSEMBED_JSOBJECTEVENTPROXY_H

#include <tqbitarray.h>
#include <tqobject.h>
#include <kjs/object.h>
#include <global.h>

namespace KJSEmbed {

class JSObjectProxy;

/**
 * Filters events for a TQObject and forwards them to a JS handler.
 *
 * @version $Id$
 * @author Richard Moore, rich@kde.org
 */
class KJSEMBED_EXPORT JSObjectEventProxy : public TQObject
{
    Q_OBJECT

public:
    JSObjectEventProxy( JSObjectProxy *parent, const char *name=0 );
    virtual ~JSObjectEventProxy();

    /** Returns true iff we forward the event type to JS. */
    bool isFiltered( TQEvent::Type t ) const;

    /** Adds an event type to those we forward to JS. */
    void addFilter( TQEvent::Type t );

    /**
     * Removes an event type from those we forward to JS. If there are no
     * event types left to forward then we self-destruct.
     */
    void removeFilter( TQEvent::Type t );

    /** Reimplemented to forward events to JS. */
    bool eventFilter ( TQObject *watched, TQEvent *e );

protected:
    KJS::Value callHandler( TQEvent *e );

private:
    JSObjectProxy *proxy;
    TQBitArray eventMask;
    uint refcount;
    class JSObjectEventProxyPrivate *d;
};

} // KJSEmbed

#endif // KJSEMBED_JSOBJECTEVENTPROXY_H

