/***************************************************************************
    begin                : Sun Oct 3 1999
    copyright            : (C) 1999 by Peter Putzer
    email                : putzer@kde.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; version 2.                              *
 *                                                                         *
 ***************************************************************************/

#ifndef KSV_VIEW_H
#define KSV_VIEW_H

#include <tqsplitter.h>
#include <tqvaluelist.h>
#include <tqsize.h>

#include <ktrader.h>

class TQPopupMenu;
class TQFileInfo;
class TQLabel;
class TQListViewItem;
class TQTextEdit;
class TQFrame;
class TQVBox;
class TQPixmap;
class TQLayout;

class KScroller;
class TDEProcess;
class TDEListView;
class TQSplitter;
class TDEPopupMenu;
class KSVTrash;
class KSVDragList;
class KSVConfig;
class KSVData;
class KSVItem;
class KSVAction;
class KSVTopLevel;

class KSVContent : public TQSplitter
{
  Q_OBJECT
  

public:
  KSVContent (TDEPopupMenu* openWithMenu, KSVTopLevel* parent = 0, const char* name = 0);
  ~KSVContent();

  KSVDragList* getOrigin();

  const TQString& log() const;
  const TQString& xmlLog() const;

  void setColors (const TQColor& newNormal,
                  const TQColor& newSelected,
                  const TQColor& changedNormal,
                  const TQColor& changedSelected);

  void mergeLoadedPackage (TQValueList<KSVData>* start,
                           TQValueList<KSVData>* stop);

public slots:
  void slotWriteSysV();

  void infoOnData(KSVItem* data);
  void setDisplayScriptOutput(bool val);
  void slotScriptProperties (TQListViewItem*);
  void multiplexEnabled (bool);

  void hideRunlevel (int index);
  void showRunlevel (int index);

protected:
  virtual void resizeEvent (TQResizeEvent* e);
  virtual void moveEvent (TQMoveEvent* e);
  virtual void showEvent (TQShowEvent*);

private slots:
  void calcMinSize ();
  void fwdOrigin (KSVDragList*);
  void startService();
  void startService (const TQString& path);
  void stopService();
  void stopService (const TQString& path);
  void restartService();
  void restartService (const TQString& path);
  void editService();
  void editService (const TQString& path);
  void slotOutputOrError( TDEProcess* _p, char* _buffer, int _buflen );
  void slotExitedProcess(TDEProcess* proc);
  void slotScriptsNotRemovable();
  void slotDoubleClick (TQListViewItem*);
  void slotExitDuringRestart(TDEProcess* proc);
  void appendLog(const TQString& rich, const TQString& plain);
  void appendLog(const TQCString& _buffer);
  void fwdCannotGenerateNumber();
  void fwdOrigin();
  void reSortRL();
  void pasteAppend();
  void fwdUndoAction(KSVAction*);
  void updatePanningFactor();

  void popupRunlevelMenu (TDEListView*, TQListViewItem*, const TQPoint&);
  void popupServicesMenu (TDEListView*, TQListViewItem*, const TQPoint&);

  void updateServicesAfterChange (const TQString&);
  void updateRunlevelsAfterChange ();

  void repaintRunlevels ();

  void openWith ();
  void openWith (int index);

signals:
  void sigUpdateParent();
  void sigRun (const TQString&);
  void sigStop();
  void sigNotRemovable();
  void cannotGenerateNumber();
  void selected (KSVItem*);
  void selectedScripts (KSVItem*);
  void sizeChanged();

  void undoAction (KSVAction*);
  void logChanged();

  void newOrigin();

private:
  static int splitterToPanningFactor (const TQValueList<int>&);
  static const TQValueList<int>& panningFactorToSplitter (int);

  void merge (TQValueList<KSVData>& list, KSVDragList* widget);
  void initLList();
  void initScripts();
  void initRunlevels();
  void info2Widget (TQFileInfo* info, int index);
  void writeToDisk (const KSVData& _w, int _rl, bool _start);
  void clearRL( int _rl );

  friend class KSVTopLevel;

  TQFrame* mContent;
  KScroller* mScroller;

  KSVDragList** startRL;
  KSVDragList** stopRL;
  KSVDragList* scripts;

  TDEPopupMenu* mItemMenu;
  TDEPopupMenu* mContextMenu;
  TDEPopupMenu* mScriptMenu;
  KSVTrash* trash;
  TQTextEdit* textDisplay;
  KSVConfig* conf;

  TQVBox* mScriptBox;
  TQVBox** mRunlevels;
  TQWidget* mBuffer;

  KSVDragList* mOrigin;

  TQString mLogText, mXMLLogText;

  TQSize mMinSize;

  TDEPopupMenu* mOpenWithMenu;
  TDETrader::OfferList mOpenWithOffers;

  TQCString m_buffer;
};

#endif
