/*
** Copyright (C) 1999,2000 Toivo Pedaste <toivo@ucs.uwa.edu.au>
**
*/

/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program in a file called COPYING; if not, write to
** the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
** MA 02110-1301, USA.
*/

/*
** Bug reports and questions can be sent to kde-devel@kde.org
*/

#ifndef SLACK_IFACE_H
#define SLACK_IFACE_H

#include "../config.h"

#include <tqptrlist.h>
#include <kprocess.h>

#include "pkgInterface.h"

class packageInfo;
class updateLoc;
class cacheObj;

class SLACK: public pkgInterface
{
  Q_OBJECT
  

public:
  SLACK();
  ~SLACK();

  bool isType(char *buf, const TQString &fname);

  packageInfo *getPackageInfo(char mode, const TQString &name,
			      const TQString &version);
  TQStringList getFileList(packageInfo *p);
  TQStringList getChangeLog(packageInfo *p);

  bool filesTab(packageInfo *p);
  // If files tab is to be enabled

  bool changeTab(packageInfo *p);
  // If change log tab is to be enabled

  TQStringList FindFile(const TQString &name, bool seachAll=false);
  bool parseName(const TQString& name, TQString *n, TQString *v);

  TQString install(int installFlags, TQPtrList<packageInfo> *plist, bool &test);

public slots:
  void setLocation();
  void setAvail(LcacheObj *);

private:
  packageInfo* collectInfo(const char *inp, int insState);
   void listInstalledPackages(TQPtrList<packageInfo> *pki);

  TQString doUninstall(int installFlags, const TQString &packs, bool &test);
  TQString doInstall(int installFlags, const TQString &packs, bool &test);

  void listPackages(TQPtrList<packageInfo> *pki);
  void listPackList(TQPtrList<packageInfo> *pki, const TQString &s,
		    cacheObj *cp, int insState);

  void initTranslate();

  void smerge(packageInfo *p);

  TQDict<TQString> *trl;
};

#endif



