 /***************************************************************************
    pluginKatexmltools.cpp
    copyright            : (C) 2001-2002 by Daniel Naber
    email                : daniel.naber@t-online.de
 ***************************************************************************/

/***************************************************************************
 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2
 of the License, or ( at your option ) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 ***************************************************************************/

#ifndef _PLUGIN_KANT_XMLTOOLS_H
#define _PLUGIN_KANT_XMLTOOLS_H

#include "pseudo_dtd.h"

#include <tqdict.h>
#include <tqstring.h>
#include <tqlistbox.h>
#include <tqprogressdialog.h>
#include <tqintdict.h>

#include <kate/plugin.h>
#include <kate/application.h>
#include <kate/view.h>
#include <kate/document.h>
#include <kate/documentmanager.h>
#include <kate/mainwindow.h>
#include <kate/viewmanager.h>

#include <tdetexteditor/codecompletioninterface.h>

#include <kcombobox.h>
#include <kdialog.h>
#include <kdialogbase.h>

class PluginKateXMLTools : public Kate::Plugin, Kate::PluginViewInterface
{

  Q_OBJECT
  

  public:

    PluginKateXMLTools( TQObject* parent = 0, const char* name = 0, const TQStringList& = TQStringList() );
    virtual ~PluginKateXMLTools();
    void addView ( Kate::MainWindow *win );
    void removeView( Kate::MainWindow *win );


  public slots:

    void getDTD();

    void slotInsertElement();
    void slotCloseElement();
    void filterInsertString( KTextEditor::CompletionEntry *ce, TQString *str );
    void completionDone( KTextEditor::CompletionEntry completionEntry );
    void completionAborted();

    void slotFinished( TDEIO::Job *job );
    void slotData( TDEIO::Job *, const TQByteArray &data );

    void backspacePressed();
    void emptyKeyEvent();
    void keyEvent( int, int, const TQString & );

    /// Connected to the document manager, to manage the dtd collection.
    void slotDocumentDeleted( uint n );

  protected:

    static TQStringList sortTQStringList( TQStringList list );
    //bool eventFilter( TQObject *object, TQEvent *event );

    TQString insideTag( Kate::View &kv );
    TQString insideAttribute( Kate::View &kv );

    bool isOpeningTag( TQString tag );
    bool isClosingTag( TQString tag );
    bool isEmptyTag( TQString tag );
    bool isQuote( TQString ch );

    TQString getParentElement( Kate::View &view, bool ignoreSingleBracket );

    enum Mode {none, entities, attributevalues, attributes, elements};
    enum PopupMode {noPopup, tagname, attributename, attributevalue, entityname};

    TQValueList<KTextEditor::CompletionEntry> stringListToCompletionEntryList( TQStringList list );

    /// Assign the PseudoDTD @p dtd to the Kate::Document @p doc
    void assignDTD( PseudoDTD *dtd, KTextEditor::Document *doc );

    /// temporary placeholder for the metaDTD file
    TQString m_dtdString;
    /// temporary placeholder for the document to assign a DTD to while the file is loaded
    KTextEditor::Document *m_docToAssignTo;
    /// URL of the last loaded meta DTD
    TQString m_urlString;

    uint m_lastLine, m_lastCol;
    TQStringList m_lastAllowed;
    int m_popupOpenCol;

    Mode m_mode;
    int m_correctPos;

    // code completion stuff:
    KTextEditor::CodeCompletionInterface* m_codeInterface;

    /// maps KTE::Document::docNumber -> DTD
    TQIntDict<PseudoDTD> m_docDtds;

    /// maps DTD filename -> DTD
    TQDict<PseudoDTD> m_dtds;

    TQPtrList<class PluginView> m_views;

    void connectSlots( Kate::View *kv );
    void disconnectSlots( Kate::View *kv );

    Kate::DocumentManager *m_documentManager;
};

class InsertElement : public KDialogBase
{

  Q_OBJECT
  

  public:
    InsertElement( TQWidget *parent, const char *name );
    ~InsertElement();
    TQString showDialog( TQStringList &completions );
  private slots:
    void slotHistoryTextChanged( const TQString& );

};

#endif // _PLUGIN_KANT_XMLTOOLS_H
// kate: space-indent on; indent-width 2; replace-tabs on; mixed-indent off;
