/* ============================================================
 * File  : sinks.cpp
 * Author: Colin Guthrie <kde@colin.guthr.ie>
 * Date  : 2007-01-14
 *
 * Copyright 2007 by Colin Guthrie <kde@colin.guthr.ie>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * ============================================================ */

#include <tqstring.h>

#include <tqwidget.h>
#include <tdeapplication.h>
#include <kdebug.h>
#include <tdeconfig.h>
#include <tdelocale.h>
#include <tdeversion.h>
#if KDE_IS_VERSION(3,2,0)
#include <tdewallet.h>
#endif

#include "sinks.h"
#include "sink.h"
#include "sinkfactory.h"

namespace KIPISyncPlugin
{

SinkTQListViewItem::SinkTQListViewItem(Sink* pSink, TQListView* pParent)
  : TQListViewItem(pParent, pSink->Name(), pSink->Type()),
    mpSink(pSink)
{
}

Sink* SinkTQListViewItem::GetSink()
{
  return mpSink;
}

void SinkTQListViewItem::Refresh()
{
  setText(0, mpSink->Name());
  setText(1, mpSink->Type());
}



Sinks::Sinks()
 : mpWallet(NULL),
   mMaxSinkId(0)
{
  TDEWallet::Wallet* p_wallet = NULL;
#if KDE_IS_VERSION(3,2,0)
  mpWallet = TDEWallet::Wallet::openWallet(TDEWallet::Wallet::NetworkWallet(),
                                         kapp->activeWindow()->winId(),
                                         TDEWallet::Wallet::Synchronous);
  if (!mpWallet)
  {
    kdWarning() << "Failed to open tdewallet" << endl;
  }
  else
  {
    if (!mpWallet->hasFolder("KIPISyncPlugin"))
    {
      if (!mpWallet->createFolder("KIPISyncPlugin"))
        kdWarning() << "Failed to create tdewallet folder" << endl;
    }

    if (!mpWallet->setFolder("KIPISyncPlugin"))
      kdWarning() << "Failed to set tdewallet folder" << endl;
    else
      p_wallet = mpWallet;
  }
#endif

  // Read config
  TDEConfig config("kipirc");
  config.setGroup("Sync Settings");
  TQValueList<int> sink_ids = config.readIntListEntry("Sinks");

  config.setGroup("Sync Sinks");
  TQString name, type;
  for (TQValueList<int>::Iterator it = sink_ids.begin(); it != sink_ids.end(); ++it)
  {
    unsigned int sink_id = (*it);

    if (sink_id > mMaxSinkId)
      mMaxSinkId = sink_id;

    type = config.readEntry(TQString("Type%1").arg(sink_id));
    name = config.readEntry(TQString("Name%1").arg(sink_id));
    Sink* p_sink = SinkFactory::Create(type, sink_id, name, &config, p_wallet);
    if (p_sink)
      mSinks.append(p_sink);
  }
}


Sinks::~Sinks()
{
  if (mpWallet)
    delete mpWallet;

  // Todo: clear up mSinks
}


/// @todo Abstract this to per-sink-type load
void Sinks::Load()
{
  static bool bln_loaded = false;
  if (bln_loaded) return;
  bln_loaded = true;
}


Sink* Sinks::Add(TQString type, TQString name)
{
  Sink* p_sink = SinkFactory::Create(type, ++mMaxSinkId, name, NULL, NULL);
  // This actually needs to be a call to sync factory creation... pass in the new SinkId
  mSinks.append(p_sink);
  return p_sink;
}

void Sinks::Remove(Sink* pSink)
{
  mSinks.remove(pSink);

  // Slight cosmetic thing for sink numbering.
  if (mSinks.isEmpty())
    mMaxSinkId = 0;
}


/// @todo Abstract this to per-sink-type save
void Sinks::Save()
{
  TQValueList<int> sink_ids;
  TDEConfig config("kipirc");
  config.deleteGroup("Sync Sinks");
  config.setGroup("Sync Sinks");

  TDEWallet::Wallet* p_wallet = NULL;
  if (mpWallet)
  {
    if (mpWallet->hasFolder("KIPISyncPlugin"))
    {
      if (!mpWallet->removeFolder("KIPISyncPlugin"))
        kdWarning() << "Failed to clear tdewallet folder" << endl;
    }
    if (!mpWallet->createFolder("KIPISyncPlugin"))
      kdWarning() << "Failed to create tdewallet folder" << endl;

    if (!mpWallet->setFolder("KIPISyncPlugin"))
      kdWarning() << "Failed to set tdewallet folder" << endl;
    else
      p_wallet = mpWallet;
  }

  for (SinkPtrList::iterator it = mSinks.begin(); it != mSinks.end(); ++it)
  {
    Sink* p_sink = (*it);
    p_sink->Save(&config, p_wallet);
    sink_ids.append(p_sink->SinkId());
  }

  config.setGroup("Sync Settings");
  config.writeEntry("Sinks", sink_ids);
}

void Sinks::asTQListView(TQListView* pListView)
{
  Load();

  pListView->clear();
  for (SinkPtrList::iterator it = mSinks.begin(); it != mSinks.end(); ++it)
  {
    //(*it)->asTQListViewItem(pListView);
  }
}

}
