/* ============================================================
 * File  : caltemplate.h
 * Author: Renchi Raju <renchi@pooh.tam.uiuc.edu>
 * Date  : 2003-11-04
 * Description :
 *
 * Copyright 2003 by Renchi Raju <renchi@pooh.tam.uiuc.edu>

 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

#ifndef CALTEMPLATE_H
#define CALTEMPLATE_H

// TQt includes.

#include <tqwidget.h>

class TQFrame;
class TQComboBox;
class TQVButtonGroup;
class TQRadioButton;
class TQCheckBox;
class TQSlider;
class TQSpinBox;
class TQLabel;
class TQTimer;

namespace KIPICalendarPlugin
{

class CalWidget;

class CalTemplate : public TQWidget
{
    Q_OBJECT
  

public:
    
    CalTemplate(TQWidget* parent, const char* name=0);
    ~CalTemplate();

private:
    
    TQComboBox*     comboPaperSize_;
    TQVButtonGroup* btnGroupImagePos_;
    TQCheckBox*     checkBoxDrawLines_;
    TQSlider*       sliderSpacing_;
    TQSlider*       sliderRatio_;
    TQComboBox*     comboFont_;
    
    CalWidget*    calWidget_;
    TQTimer*       timer_;
    int           previewSize_;

private slots:

    void slotParamsChanged();
    void slotUpdatePreview();
    
};

}  // NameSpace KIPICalendarPlugin

#endif // CALTEMPLATE_H
