/*

Copyright (C) 2010 Timothy Pearson <kb9vqf@pearsoncomputing.net>

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public
License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public License
along with this library; see the file COPYING.LIB.  If not, write to
the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
Boston, MA 02110-1301, USA.

*/

#ifndef TQT_TQLISTITERATOR_H
#define TQT_TQLISTITERATOR_H

#include <tqt.h>

#ifdef USE_QT4

// Implement the TQListIterator class
// For Qt4, this is a combination of the QList::iterator and QMutableListIterator classes,
// with the constructor from QMutableListIterator used primarily

//#include <QMutableListIterator>
#include <Qt/ntqlist.h>

template <typename T>
//class TQListIterator : public QList<T>::iterator
//class TQListIterator : public QMutableListIterator
class TQListIterator
{
public:
	inline TQListIterator(const QList<T> &t) {index = 0; list = &t;}
	inline ~TQListIterator() {}

	inline T current() {
		if ((index >= 0) && (index < list->size())) {
			return list->at(index);
		}
		else {
			return 0;
		}
	}

	int operator++() { index++; return index; }

private:
	int index;
	const QList<T> *list;
};

template <typename T>
class TQListIteratorRetPtr
{
public:
	inline TQListIteratorRetPtr(const QList<T> &t) {index = 0; list = &t;}
	inline ~TQListIteratorRetPtr() {}

	inline T * current() {
		if ((index >= 0) && (index < list->size())) {
			return const_cast<QFileInfo *>(&(list->at(index)));
		}
		else {
			return 0;
		}
	}

	int operator++() { index++; return index; }

private:
	int index;
	const QList<T> *list;
};

#endif // USE_QT4

#endif /* TQT_TQLISTITERATOR_H */
