#!/usr/bin/env python

# TQt tutorial 7.

import sys
from python_tqt.qt import *


class LCDRange(TQVBox):
    def __init__(self,parent=None,name=None):
        TQVBox.__init__(self,parent,name)

        lcd = TQLCDNumber(2,self,'lcd')
        self.slider = TQSlider(TQt.Horizontal,self,'slider')
        self.slider.setRange(0,99)
        self.slider.setValue(0)
        self.connect(self.slider,SIGNAL('valueChanged(int)'),lcd,SLOT('display(int)'))
        self.connect(self.slider,SIGNAL('valueChanged(int)'),self,PYSIGNAL('valueChanged(int)'))

    def value(self):
        return self.slider.value()

    def setValue(self,value):
        self.slider.setValue(value)


class MyWidget(TQVBox):
    def __init__(self,parent=None,name=None):
        TQVBox.__init__(self,parent,name)

        quit = TQPushButton("Quit",self,"quit")
        quit.setFont(TQFont("Times",18,TQFont.Bold))

        self.connect(quit,SIGNAL("clicked()"),tqApp,SLOT("quit()"))

        grid = TQGrid(4,self)

        self.lcdlist = []
        previous = None

        for r in range(4):
            for c in range(4):
                lr = LCDRange(grid)

                if previous is not None:
                    self.connect(lr,PYSIGNAL("valueChanged(int)"),previous.setValue)

                previous = lr
                self.lcdlist.append(lr)


a = TQApplication(sys.argv)

w = MyWidget()
a.setMainWidget(w)
w.show()
a.exec_loop()
