/*
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
*/

/*
  Copyright (C) 2005 Francois Chazal <neptune3k@free.fr>
  Copyright (C) 2006-2007 Eike Hein <hein@kde.org>
*/


#ifndef IMAGE_BUTTON_H
#define IMAGE_BUTTON_H


#include "translucent_widget.h"

#include <tqurl.h>
#include <tqcolor.h>
#include <tqpoint.h>
#include <tqbitmap.h>
#include <tqpixmap.h>
#include <tqpainter.h>
#include <tqpopupmenu.h>

#include <krootpixmap.h>


class ImageButton : public TranslucentWidget
{
    Q_OBJECT
  

    public:
        explicit ImageButton(TQWidget* parent = 0, const char* name = 0, bool translucency = false);
        ~ImageButton();

        /* Creates a toggle button */
        void setToggleButton(bool toggled);
        void setToggled(bool enable);

        /* Sets the configuration menu */
        void setPopupMenu(TQPopupMenu* menu);
        void setDelayedPopup(bool delay) { delay_popup = delay; }

        /* Sets the widget's pixmaps */
        void setUpPixmap(const TQString& path, bool use_alpha_mask = false);
        void setOverPixmap(const TQString& path);
        void setDownPixmap(const TQString& path);


    signals:
        void clicked();
        void toggled(bool toggled);


    protected:
        virtual void enterEvent(TQEvent*);
        virtual void leaveEvent(TQEvent*);

        virtual void paintEvent(TQPaintEvent*);

        virtual void mousePressEvent(TQMouseEvent*);
        virtual void mouseReleaseEvent(TQMouseEvent*);


    private:
        int state;
        bool toggle;
        bool pressed;
        bool delay_popup;

        TQTimer* popup_timer;

        /* Widget's mask */
        TQRegion mask;

        /* Widget's tip */
        TQString tooltip;

        /* Widget's pixmaps */
        TQPixmap up_pixmap;
        TQPixmap over_pixmap;
        TQPixmap down_pixmap;

        /* Widget's popup menu */
        TQPopupMenu* popup_menu;


    private slots:
        void showPopupMenu();
};

#endif /* IMAGE_BUTTON_H */
