/***************************************************************************
 * $Id: usability.ui.h,v 1.12 2008/07/31 19:56:28 hoganrobert Exp $
 *   Copyright (C) 2006 - 2008 Robert Hogan                                *
 *   robert@roberthogan.net                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.              *
 ***************************************************************************/


#include "torkconfig.h"
#include "portsandnames.h"
#include <tdelocale.h>
#include <ntqtooltip.h>
#include <ntqpopupmenu.h>
#include <kdebug.h>


void Usability::init()
{
    TQListViewItemIterator it(LongLivedPorts);
    while ( it.current() ) {
        int i;
        TQString port;
        for (i = 0; _port_name[i].port; ++i) {
            portsandnames_t *pics = &_port_name[i];
            if (it.current()->text(0) == pics->name){
                port = pics->port;
                continue;
            }
        }

        if (TorkConfig::longLivedPorts().contains(port))
            LongLivedPorts->setSelected(*it,true);
        ++it;
    }

    TQStringList existingTracks = TorkConfig::trackHostExits();
    TQListViewItem *tm;
	for ( TQStringList::Iterator it = existingTracks.begin(); it != existingTracks.end(); ++it )
	{
		if ((*it).isEmpty())
			continue;
        tm = new TQListViewItem(TrackHostExits,(*it));
    }

}
void Usability::LongLivedPorts_selectionChanged()
{
    emit settingsChanged();
}




void Usability::PushAdd_clicked()
{

    new TQListViewItem(TrackHostExits,NewHost->text());
}



void Usability::TrackHostExits_contextMenuRequested( TQListViewItem *, const TQPoint &point, int )
{

    TQPopupMenu *menu = new TQPopupMenu( TrackHostExits );

    menu->clear();
    menu->insertItem( "Delete Entry", this,SLOT(slotDeleteEntry()) );
    menu->popup( point );

}


void Usability::slotDeleteEntry( )
{

    TQListViewItemIterator it(TrackHostExits, TQListViewItemIterator::Selected);
    while ( it.current() ) {
        if (TrackHostExits->isSelected( it.current()))
            delete it.current();
        ++it;
    }


}


// <connections>
//     <connection>
//         <sender>LongLivedPorts</sender>
//         <signal>selectionChanged()</signal>
//         <receiver>Usability</receiver>
//         <slot>LongLivedPorts_selectionChanged()</slot>
//     </connection>
//     <connection>
//         <sender>TrackHostExits</sender>
//         <signal>contextMenuRequested(TQListViewItem*,const TQPoint&amp;,int)</signal>
//         <receiver>Usability</receiver>
//         <slot>TrackHostExits_contextMenuRequested(TQListViewItem*,const TQPoint&amp;,int)</slot>
//     </connection>
//     <connection>
//         <sender>PushAdd</sender>
//         <signal>clicked()</signal>
//         <receiver>Usability</receiver>
//         <slot>PushAdd_clicked()</slot>
//     </connection>
// </connections>
// <includes>
//     <include location="local" impldecl="in implementation">usability.ui.h</include>
// </includes>
// <signals>
//     <signal>settingsChanged()</signal>
// </signals>
// <slots>
//     <slot>LongLivedPorts_selectionChanged()</slot>
//     <slot>TrackHostExits_contextMenuRequested( TQListViewItem *, const TQPoint &amp; point, int )</slot>
//     <slot>slotDeleteEntry()</slot>
//     <slot>PushAdd_clicked()</slot>
// </slots>
// <functions>
//     <function access="private" specifier="non virtual">init()</function>
// </functions>
// <layoutdefaults spacing="6" margin="11"/>
// </UI>



void Usability::clearSelected_clicked()
{

    TQListViewItemIterator it(LongLivedPorts, TQListViewItemIterator::Selected);
    while ( it.current() ) {
        it.current()->listView()->setSelected(it.current(),false);
        ++it;
    }

}
