/***************************************************************************
 * $Id: running.ui.h,v 1.10 2008/07/31 19:56:26 hoganrobert Exp $
 *   Copyright (C) 2006 - 2008 Robert Hogan                                *
 *   robert@roberthogan.net                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.              *
 ***************************************************************************/

//dummy
#include "torkconfig.h"
#include <tdelocale.h>
#include <ntqtooltip.h>
#include <ntqpopupmenu.h>
#include <kdebug.h>

void Running::init()
{

    TQStringList existingMaps = TorkConfig::sOCKSBindAddressMany();
    TQListViewItem *tm;
	for ( TQStringList::Iterator it = existingMaps.begin(); it != existingMaps.end(); ++it )
	{
		if ((*it).isEmpty())
			continue;
        TQString entry = (*it).section(":",0,0);
        TQString port = (*it).section(":",1,1);

        tm = new TQListViewItem(SOCKSBindAddressMany,entry,port);
    }

    TQStringList existingSocksPolicies = TorkConfig::sOCKSPolicy();

	for ( TQStringList::Iterator it = existingSocksPolicies.begin(); it != existingSocksPolicies.end(); ++it )
	{
		if ((*it).isEmpty())
			continue;
        TQString policy = (*it).section(" ",0,0);
        TQString section2 = (*it).section(" ",1,1);
        TQString entry = section2.section(":",0,0);
        TQString port = section2.section(":",1,1);


        tm = new TQListViewItem(SOCKSPolicy,policy,entry,port);
    }

    
}
void Running::PushAdd_clicked()
{
    new TQListViewItem(SOCKSBindAddressMany,Address->text(), Port->text());
}

void Running::PushAdd2_clicked()
{
    new TQListViewItem(SOCKSPolicy,Policy->currentText(),SocksAddress->text(), SocksPort->text());
}


void Running::SOCKSBindAddressMany_contextMenuRequested( TQListViewItem *, const TQPoint &point, int )
{

    TQPopupMenu *menu = new TQPopupMenu( SOCKSBindAddressMany );

    menu->clear();
    menu->insertItem( "Delete Entry", this,SLOT(slotDeleteEntry()) );
    menu->popup( point );

}


void Running::slotDeleteEntry( )
{

    TQListViewItemIterator it(SOCKSBindAddressMany, TQListViewItemIterator::Selected);
    while ( it.current() ) {
        if (SOCKSBindAddressMany->isSelected( it.current()))
            delete it.current();
        ++it;
    }

}


void Running::SOCKSPolicy_contextMenuRequested( TQListViewItem *, const TQPoint &point, int )
{

    TQPopupMenu *menu = new TQPopupMenu( SOCKSPolicy );

    menu->clear();
    menu->insertItem( "Delete Entry", this,SLOT(slotDeletePolicyEntry()) );
    menu->popup( point );

}


void Running::slotDeletePolicyEntry( )
{

    TQListViewItemIterator it(SOCKSPolicy, TQListViewItemIterator::Selected);
    while ( it.current() ) {
        if (SOCKSPolicy->isSelected( it.current()))
            delete it.current();
        ++it;
    }


}


void Running::kcfg_DefaultRunningNormalOptions_toggled( bool state)
{
    NormalOptions->setEnabled(!state);
}



void Running::kcfg_CookieAuthentication_toggled( bool )
{
    if ( kcfg_CookieAuthentication->isChecked()){
        kcfg_HashedControlPassword->setEnabled(false);
    }else{
        kcfg_HashedControlPassword->setEnabled(true);
    }
}


void Running::kcfg_HashedControlPassword_textChanged( const TQString & )
{
    if (! kcfg_HashedControlPassword->text().isEmpty()){
        kcfg_CookieAuthentication->setEnabled(false);
    }else{
        kcfg_CookieAuthentication->setEnabled(true);
    }

}


// <connections>
//     <connection>
//         <sender>SOCKSPolicy</sender>
//         <signal>contextMenuRequested(TQListViewItem*,const TQPoint&amp;,int)</signal>
//         <receiver>Running</receiver>
//         <slot>SOCKSPolicy_contextMenuRequested(TQListViewItem*,const TQPoint&amp;,int)</slot>
//     </connection>
//     <connection>
//         <sender>SOCKSBindAddressMany</sender>
//         <signal>contextMenuRequested(TQListViewItem*,const TQPoint&amp;,int)</signal>
//         <receiver>Running</receiver>
//         <slot>SOCKSBindAddressMany_contextMenuRequested(TQListViewItem*,const TQPoint&amp;,int)</slot>
//     </connection>
//     <connection>
//         <sender>PushAdd</sender>
//         <signal>clicked()</signal>
//         <receiver>Running</receiver>
//         <slot>PushAdd_clicked()</slot>
//     </connection>
//     <connection>
//         <sender>PushAdd2</sender>
//         <signal>clicked()</signal>
//         <receiver>Running</receiver>
//         <slot>PushAdd2_clicked()</slot>
//     </connection>
//     <connection>
//         <sender>kcfg_DefaultRunningNormalOptions</sender>
//         <signal>toggled(bool)</signal>
//         <receiver>Running</receiver>
//         <slot>kcfg_DefaultRunningNormalOptions_toggled(bool)</slot>
//     </connection>
//     <connection>
//         <sender>kcfg_HashedControlPassword</sender>
//         <signal>textChanged(const TQString&amp;)</signal>
//         <receiver>Running</receiver>
//         <slot>kcfg_HashedControlPassword_textChanged(const TQString&amp;)</slot>
//     </connection>
//     <connection>
//         <sender>kcfg_CookieAuthentication</sender>
//         <signal>toggled(bool)</signal>
//         <receiver>Running</receiver>
//         <slot>kcfg_CookieAuthentication_toggled(bool)</slot>
//     </connection>
//     <connection>
//         <sender>kcfg_ClientOnly</sender>
//         <signal>toggled(bool)</signal>
//         <receiver>Running</receiver>
//         <slot>kcfg_ClientOnly_toggled(bool)</slot>
//     </connection>
// </connections>
// <includes>
//     <include location="local" impldecl="in implementation">running.ui.h</include>
// </includes>
// <slots>
//     <slot>PushAdd_clicked()</slot>
//     <slot>PushAdd2_clicked()</slot>
//     <slot>SOCKSBindAddressMany_contextMenuRequested( TQListViewItem *, const TQPoint &amp; point, int )</slot>
//     <slot>slotDeleteEntry()</slot>
//     <slot>SOCKSPolicy_contextMenuRequested( TQListViewItem *, const TQPoint &amp; point, int )</slot>
//     <slot>slotDeletePolicyEntry()</slot>
//     <slot>kcfg_DefaultRunningNormalOptions_toggled( bool state )</slot>
//     <slot>kcfg_HashedControlPassword_textChanged( const TQString &amp; )</slot>
//     <slot>kcfg_CookieAuthentication_toggled( bool )</slot>
//     <slot>kcfg_ClientOnly_toggled( bool state )</slot>
// </slots>
// <functions>
//     <function access="private" specifier="non virtual">init()</function>
// </functions>
// <layoutdefaults spacing="6" margin="11"/>
// <includehints>
//     <includehint>kurlrequester.h</includehint>
//     <includehint>kcombobox.h</includehint>
//     <includehint>kpushbutton.h</includehint>
// </includehints>




