/***************************************************************************
                          pluginmanager.h  -  description
                             -------------------
    begin                : Mon Apr 28 2003
    copyright            : (C) 2003 by Martin Witte
    email                : witte@kawo1.rwth-aachen.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KRADIO_PLUGINMANAGER_INTERFACES_H
#define KRADIO_PLUGINMANAGER_INTERFACES_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <tqstring.h>
#include <tqptrdict.h>

#include "plugins.h"

class PluginBase;
class WidgetPluginBase;
class PluginConfigurationDialog;
class PluginManagerConfiguration;
class TQWidget;
class TDEConfig;
class TQFrame;
class TDEAboutDialog;
class KDialogBase;

struct ConfigPageInfo;
class TQMenuData;
class TDERadioApp;


class PluginManager : public TQObject
{
Q_OBJECT
  
public :
             PluginManager(const TQString &name,
                           TDERadioApp *app,
                           const TQString &configDialogTitle,
                           const TQString &aboutTitle);
    virtual ~PluginManager();

    // Library Functions

    void                 noticeLibrariesChanged();
    void                 unloadPlugins(const TQString &class_name);

    // managing plugins

    const PluginList    &plugins() const { return m_plugins; }
    void                 addWidgetPluginMenuItems(TQMenuData *menu, TQMap<WidgetPluginBase *,int> &map) const;
    void                 updateWidgetPluginMenuItem(WidgetPluginBase *p, TQMenuData *menu, TQMap<WidgetPluginBase *,int> &map, bool shown) const;

    PluginBase          *getPluginByName(const TQString &name) const;

    // after insert, pluginManager is responsible for deletion
    void                 insertPlugin(PluginBase *);

    // remove and delete plugin
    void                 deletePlugin(PluginBase *);
    void                 deletePluginByName(const TQString &name) { deletePlugin(getPluginByName(name)); }

    // remove plugin, afterwards pluginManager is no longer responsible for deletion
    void                 removePlugin(PluginBase *);
    void                 removePluginByName(const TQString &name) { removePlugin(getPluginByName(name)); }

    // operations on all plugins

    virtual void         saveState    (TDEConfig *) const;
    virtual void         restoreState (TDEConfig *);
    virtual void         startPlugins();

    // configuration dialog handling

    virtual PluginConfigurationDialog *getConfigDialog();
    virtual KDialogBase               *getAboutDialog();
    virtual bool                       showsProgressBar() const { return m_showProgressBar; }
    virtual void                       showProgressBar(bool b) { m_showProgressBar = b; }

    virtual void         noticeWidgetPluginShown(WidgetPluginBase *p, bool shown);

protected :
    virtual void         createConfigDialog(const TQString &title = TQString());
    virtual void         createAboutDialog (const TQString &title = TQString());

    virtual void         addConfigurationPage (PluginBase *forWhom,
                                               const ConfigPageInfo    &info);
    virtual void         addAboutPage         (PluginBase *forWhom,
                                               const AboutPageInfo     &info);

protected slots:

    virtual void         slotConfigOK();

public slots:
    virtual void         aboutToQuit();

signals:

    virtual void         sigConfigOK();

private:
    virtual TQFrame      *addConfigurationPage (const ConfigPageInfo    &info);
    ConfigPageInfo       createOwnConfigurationPage();

    // PluginManager's data & types ;)
protected:
    typedef TQPtrDict<TQFrame>               TQFrameDict;
    typedef TQPtrDictIterator<TQFrame>       TQFrameDictIterator;
    typedef TQPtrDict<TQWidget>              TQWidgetDict;
    typedef TQPtrDictIterator<TQWidget>      TQWidgetDictIterator;

    TQString      m_Name;
    TDERadioApp   *m_Application;

    PluginList   m_plugins;
    bool         m_showProgressBar;

    TQFrameDict   m_configPageFrames;
    TQWidgetDict  m_configPages;

    TQFrameDict   m_aboutPageFrames;
    TQWidgetDict  m_aboutPages;

    PluginConfigurationDialog *m_configDialog;
    PluginManagerConfiguration*m_pluginManagerConfiguration;
    KDialogBase               *m_aboutDialog;
    TQString                    m_configDialogTitle;
    TQString                    m_aboutDialogTitle;
};




#endif
