

#ifndef OUTPUTDIRECTORY_H
#define OUTPUTDIRECTORY_H

#include <tqwidget.h>
#include <kprocess.h>

class FileListItem;

class Config;
class KComboBox;
class KLineEdit;
class TDEToolBarButton;

/**
 * @short The input area for the output directory
 * @author Daniel Faust <hessijames@gmail.com>
 * @version 0.3
 */
class OutputDirectory : public TQWidget
{
    Q_OBJECT
  
public:
    enum Mode {
//         Default,
        MetaData,
        Source,
        Specify,
        CopyStructure
    };

    /**
     * Constructor
     */
    OutputDirectory( Config*, TQWidget* parent = 0, const char* name = 0 );

    Mode mode();
    void setMode( Mode );
    TQString directory();
    void setDirectory( const TQString& );

    static TQString calcPath( FileListItem* fileListItem, Config* config, TQString extension = "" );
    static TQString changeExtension( const TQString& filename, const TQString& extension );
    static TQString uniqueFileName( const TQString& filename );
    static TQString makePath( const TQString& path );
    static TQString vfatPath( const TQString& path );

    /**
     * Destructor
     */
    virtual ~OutputDirectory();

public slots:
    //void setActive( bool );
    void enable();
    void disable();

private slots:
    void modeChangedSlot( int );
    void directoryChangedSlot( const TQString& );
    void selectDir();
    void gotoDir();
    //void modeInfo();
    //void dirInfo();
    //void savePaths();

private:
    KComboBox* cMode;
    //TDEToolBarButton* pModeInfo;
    KLineEdit* lDir;
    TDEToolBarButton* pDirSelect;
    TDEToolBarButton* pDirGoto;
    //TDEToolBarButton* pDirInfo;
    TDEToolBarButton* pClear;

    bool modeJustChanged;

    TDEProcess kfm;

    Config* config;

/*    TQString sharedDirPath;
    TQString metadataPath;
    TQString copyStructurePath;
*/
signals:
    void modeChanged( OutputDirectory::Mode );
    void directoryChanged( const TQString& );
};

#endif // OUTPUTDIRECTORY_H
