#!/bin/sh

# Smart Card Authentication Helper (c) 2008 Timothy Pearson
#
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.


authscript="C0 84 00 00 08"
echo $authscript > authscript

scriptor_standalone authscript | grep 'Normal processing' > challenge
perl -pi -e 's/ //g' challenge
perl -pi -e 's/:Normalprocessing.//g' challenge
perl -pi -e 's/<//g' challenge
xxd -r -p challenge challenge

# Now DES encrypt the challenge
openssl des-ecb -in challenge -out response -K 0000000000000000 -iv 1

# Truncate to 6 bytes
dd if=response of=response2 bs=1 count=6

# Expand to standard hex listing format
xxd -g 1 response2 response
dd if=response of=response2 bs=1 count=17 skip=9

# Assemble the response file
response2=$(cat response2)
response1="C0 82 00 00 07 01 ${response2}"
echo $response1 > response

# Send the response!
scriptor_standalone response > response2

# Get the result
dd if=response2 of=response bs=1 count=5 skip=95
perl -pi -e 's/ //g' response
response1=$(cat response)
authokresponse="9000"
if [ "$response1" = "$authokresponse" ]; then
	echo "Smart card validation successfull!"
	# Get encryption key
	authscript="C0 A4 00 00 02 10 01"
	echo $authscript > authscript
	scriptor_standalone authscript
	#authscript="C0 B0 00 00 00"
	authscript=""
	echo $authscript > authscript
	scriptor_standalone authscript > smart
	mkdir smartcard
	cd smartcard
	echo "get 1001" | opensc-explorer
	cd ..
	rm smart
	mv smartcard/*_1001 smart.key
else
	echo "Authentication failed!"
fi

rm authscript &
rm response &
rm response2 &
rm challenge &
