#!/bin/sh

# Part of passwordless cryptofs setup in Debian Etch.
# See: http://wejn.org/how-to-make-passwordless-cryptsetup.html
# Author: Wejn <wejn at box dot cz>
#
# Updated by Rodolfo Garcia (kix) <kix at kix dot com>
# For multiple partitions
# http://www.kix.es/
#
# Updated by TJ <linux@tjworld.net> 7 July 2008
# For use with Ubuntu Hardy, usplash, automatic detection of USB devices,
# detection and examination of *all* partitions on the device (not just partition #1), 
# automatic detection of partition type, refactored, commented, debugging code.
#
# Update by Timothy Pearson <kb9vqf@pearsoncomputing.net> 8/28/2008
# Modified for use with SmartCard script instead of USB key
#
# Updated by Timothy Pearson <kb9vqf@pearsoncomputing.net> 4/19/2010
# Added Plymouth detection and support

# define counter-intuitive shell logic values (based on /bin/true & /bin/false)
TRUE=0
FALSE=1

# set DEBUG=$TRUE to display debug messages, DEBUG=$FALSE to be quiet
DEBUG=$FALSE

# Fix the aggressive usplash timeout
if [ -x /sbin/usplash_write ]; then
	/sbin/usplash_write "TIMEOUT 180" || true
fi

# Find plymouth
PLYDIR=/bin/plymouth

# print message to usplash or stderr
# usage: msg <command> "message" [switch]
# command: TEXT | STATUS | SUCCESS | FAILURE | CLEAR (see 'man usplash_write' for all commands)
# switch : switch used for echo to stderr (ignored for usplash)
# when using usplash the command will cause "message" to be
# printed according to the usplash <command> definition.
# using the switch -n will allow echo to write multiple messages
# to the same line
# msg ()
# {
# 	if [ -p /dev/.initramfs/usplash_outfifo ] && [ -x /sbin/usplash_write ]; then
# 		usplash_write "TEXT-URGENT $@"
# 	else
# 		echo "$@" >&2
# 	fi
# 	return 0
# }

msg ()
{
	HAS_PLYMOUTH=0
	if [ -e $PLYDIR ]; then
		plymouth --ping
		if [ $? -eq 0 ]; then
			HAS_PLYMOUTH=1
		fi
	fi
	if [ $HAS_PLYMOUTH -eq 1 ]; then
		plymouth message --text="$@"
	else
		if [ -p /dev/.initramfs/usplash_outfifo ] && [ -x /sbin/usplash_write ]; then
			usplash_write "TEXT-URGENT $@"
		else
			echo "$@" >&2
		fi
	fi
	return 0
}

[ $DEBUG -eq $TRUE ] && msg "Executing cryptosmartcard.sh ..."
# flag tracking key-file availability
OPENED=$FALSE

# Is the USB driver loaded?
cat /proc/modules | busybox grep usb_storage >/dev/null 2>&1
USBLOAD=0$?
if [ $USBLOAD -gt 0 ]; then
	[ $DEBUG -eq $TRUE ] && msg "Loading driver 'usb_storage'"
	modprobe usb_storage >/dev/null 2>&1
fi

killall pcscd &

# give the system time to settle and open the USB devices
sleep 5

cd /bin/
/bin/smartauth.sh > /dev/null 2>&1
SMARTCARDFILE=/bin/smart.key
if [ -e $SMARTCARDFILE ]
then
	OPENED=$TRUE
	cat $SMARTCARDFILE
else
	OPENED=$FALSE
fi

if [ $OPENED -eq $FALSE ]; then
	msg "SmartCard LUKS keyfile invalid or incorrect SmartCard inserted"
	if [ $HAS_PLYMOUTH -eq 1 ]; then
		plymouth ask-for-password --prompt="Please enter the LUKS password"
	else
		msg "Please enter the LUKS password: "
		read -s -r A < /dev/console
		echo -n "$A"
		msg "Attempting to authenticate..."
	fi
else
	msg "SmartCard authenticated and LUKS keyfile loaded"
fi

killall pcscd &


