// -*- c-basic-offset: 4 -*-

/*
    Rosegarden
    A sequencer and musical notation editor.

    This program is Copyright 2000-2008
        Guillaume Laurent   <glaurent@telegraph-road.org>,
        Chris Cannam        <cannam@all-day-breakfast.com>,
        Richard Bown        <bownie@bownie.com>

    This file contains code borrowed from KDevelop 2.0
    Copyright (c) The KDevelop Development Team.

    The moral right of the authors to claim authorship of this work
    has been asserted.

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of the
    License, or (at your option) any later version.  See the file
    COPYING included with this distribution for more information.
*/

#ifndef KSTARTUPLOGO_H
#define KSTARTUPLOGO_H

#include <tqwidget.h>
#include <tqpixmap.h>

class TDEStartupLogo : public TQWidget
{
    Q_OBJECT
  

public:
    static TDEStartupLogo* getInstance();

    static void hideIfStillThere();
    
    void setHideEnabled(bool enabled) { m_readyToHide = enabled; };
    void setShowTip(bool showTip) { m_showTip = showTip; };

public slots:
    void slotShowStatusMessage(TQString);
    virtual void close();

protected:

    TDEStartupLogo(TQWidget *parent=0, const char *name=0);
    ~TDEStartupLogo();
    
    virtual void paintEvent(TQPaintEvent*);
    virtual void mousePressEvent( TQMouseEvent*);

    bool m_readyToHide;
    bool m_showTip;

    TQPixmap m_pixmap;

    static TDEStartupLogo* m_instance;
    static bool m_wasClosed;
    TQString m_statusMessage;
};

#endif





