/* -*- c-basic-offset: 4 indent-tabs-mode: nil -*- vi:set ts=8 sts=4 sw=4: */

/*
    Rosegarden
    A MIDI and audio sequencer and musical notation editor.
 
    This program is Copyright 2000-2008
        Guillaume Laurent   <glaurent@telegraph-road.org>,
        Chris Cannam        <cannam@all-day-breakfast.com>,
        Richard Bown        <richard.bown@ferventsoftware.com>
 
    The moral rights of Guillaume Laurent, Chris Cannam, and Richard
    Bown to claim authorship of this work have been asserted.
 
    Other copyrights also apply to some parts of this work.  Please
    see the AUTHORS file and individual file headers for details.
 
    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of the
    License, or (at your option) any later version.  See the file
    COPYING included with this distribution for more information.
*/


#include "PitchPickerDialog.h"
#include <tdelocale.h>
#include <kdialogbase.h>
#include <tqlayout.h>
#include <tqframe.h>
#include <tqstring.h>
#include <tqvbox.h>
#include <tqwidget.h>


namespace Rosegarden
{

PitchPickerDialog::PitchPickerDialog(TQWidget *parent, int initialPitch, TQString text) :
        KDialogBase(parent, 0, true, i18n("Pitch Selector"), Ok | Cancel)
{
    TQVBox *vBox = makeVBoxMainWidget();

    TQFrame *frame = new TQFrame(vBox);

    TQGridLayout *layout = new TQGridLayout(frame, 4, 3, 10, 5);

    m_pitch = new PitchChooser(text, frame, initialPitch);
    layout->addMultiCellWidget(m_pitch, 0, 0, 0, 2, TQt::AlignHCenter);
}

PitchPickerDialog::~PitchPickerDialog()
{
    // Nothing here...
}

}
#include "PitchPickerDialog.moc"
