/* -*- c-basic-offset: 4 indent-tabs-mode: nil -*- vi:set ts=8 sts=4 sw=4: */

/*
    Rosegarden
    A MIDI and audio sequencer and musical notation editor.

    This program is Copyright 2000-2008
        Guillaume Laurent   <glaurent@telegraph-road.org>,
        Chris Cannam        <cannam@all-day-breakfast.com>,
        Richard Bown        <richard.bown@ferventsoftware.com>

    The moral rights of Guillaume Laurent, Chris Cannam, and Richard
    Bown to claim authorship of this work have been asserted.

    Other copyrights also apply to some parts of this work.  Please
    see the AUTHORS file and individual file headers for details.

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of the
    License, or (at your option) any later version.  See the file
    COPYING included with this distribution for more information.
*/

#ifndef _RG_AUDIOCONFIGURATIONPAGE_H_
#define _RG_AUDIOCONFIGURATIONPAGE_H_

#include "TabbedConfigurationPage.h"
#include <tqstring.h>
#include <tdelocale.h>
#include <tqlineedit.h>

class TQWidget;
class TQSpinBox;
class TQSlider;
class TQPushButton;
class TQLabel;
class TQComboBox;
class TQCheckBox;
class TDEConfig;
class KComboBox;


namespace Rosegarden
{

class RosegardenGUIDoc;


class AudioConfigurationPage : public TabbedConfigurationPage
{
    Q_OBJECT
  
public:
    AudioConfigurationPage(RosegardenGUIDoc *doc,
                               TDEConfig *cfg,
                               TQWidget *parent=0,
                               const char *name=0);

    virtual void apply();

    static TQString iconLabel() { return i18n("Audio"); }
    static TQString title()     { return i18n("Audio Settings"); }
    static TQString iconName()  { return "configure-audio"; }

#ifdef HAVE_LIBJACK
    TQString getJackPath() { return m_jackPath->text(); }
#endif // HAVE_LIBJACK

    static TQString getBestAvailableAudioEditor();

protected slots:
    void slotFileDialog();

protected:
    TQString getExternalAudioEditor() { return m_externalAudioEditorPath->text(); }


    //--------------- Data members ---------------------------------

#ifdef HAVE_LIBJACK
    TQCheckBox *m_startJack;
    TQLineEdit *m_jackPath;
#endif // HAVE_LIBJACK


#ifdef HAVE_LIBJACK
    // Number of JACK input ports our RG client creates - 
    // this decides how many audio input destinations
    // we have.
    //
    TQCheckBox    *m_createFaderOuts;
    TQCheckBox    *m_createSubmasterOuts;

    TQComboBox    *m_audioRecFormat;

#endif // HAVE_LIBJACK

    TQLineEdit* m_externalAudioEditorPath;
    TQComboBox* m_previewStyle;

};
 


}

#endif
