

#ifndef __OPTIONS_INSTANCES_H__
#define __OPTIONS_INSTANCES_H__

//
//   File : instances.h
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2001-2006 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
//

//
// Instance creation routines for the KVIrc options module
// DO NOT EDIT THIS FILE!! ALL CHANGES WILL BE LOST!!
// This file is automatically generated by mkcreateinstanceproc.sh
// so any change should go in that script
//

#include "kvi_optionswidget.h"
#include "kvi_module.h"
#include "kvi_pointerlist.h"
#include "kvi_qstring.h"

typedef struct _KviOptionsWidgetInstanceEntry KviOptionsWidgetInstanceEntry;


typedef struct _KviOptionsWidgetInstanceEntry
{
	KviOptionsWidget                          * (*createProc)(TQWidget *);
	KviOptionsWidget                          * pWidget;   // singleton
	int                                         iIcon;
	TQString                                     szName;
	TQString                                     szNameNoLocale;
	const char                                * szClassName;
	int                                         iPriority;
	TQString                                     szKeywords;
	TQString                                     szKeywordsNoLocale;
	TQString                                     szGroup;
	bool                                        bIsContainer;
	bool                                        bIsNotContained;
	KviPointerList<KviOptionsWidgetInstanceEntry> * pChildList;
	bool                                        bDoInsert; // a helper for KviOptionsDialog::fillListView()
} KviOptionsWidgetInstanceEntry;


class KviOptionsInstanceManager : public TQObject
{
	Q_OBJECT
	
public:
	KviOptionsInstanceManager();
	virtual ~KviOptionsInstanceManager();
protected:
	KviPointerList<KviOptionsWidgetInstanceEntry> *  m_pInstanceTree;
public:
	KviPointerList<KviOptionsWidgetInstanceEntry> * instanceEntryTree(){ return m_pInstanceTree; };
	KviOptionsWidget * getInstance(KviOptionsWidgetInstanceEntry * e,TQWidget * par);
	KviOptionsWidgetInstanceEntry * findInstanceEntry(const char * clName);
	void cleanup(KviModule * m);
protected:
	KviOptionsWidgetInstanceEntry * findInstanceEntry(const char * clName,KviPointerList<KviOptionsWidgetInstanceEntry> * l);
	KviOptionsWidgetInstanceEntry * findInstanceEntry(const TQObject * ptr,KviPointerList<KviOptionsWidgetInstanceEntry> * l);
	void deleteInstanceTree(KviPointerList<KviOptionsWidgetInstanceEntry> * l);
protected slots:
	void widgetDestroyed();
};

#endif //__OPTIONS_INSTANCES_H__

