//
// C++ Interface: types
//
// Description:
// All specail types for KShowMail
//
//
// Author: Ulrich Weigelt <ulrich.weigelt@gmx.de>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//

#ifndef TYPES_H
#define TYPES_H

//TQt headers
#include <tqvaluelist.h>
#include <tqmap.h>
#include <tqstring.h>
#include <list>
using namespace std;

/**
 * All special types for KShowMail.
 */
namespace Types
{
     /**
      * State of the application during running time.
      */
     enum State_Type {idle,                  /**<it's doing nothing*/

                      deleting,              /**<it's deleting a message on the server*/

                      configure,             /**<the user is configuring the application or
                                              * the mail or just the header of the mail is
                                              * being shown*/

                      executing,             /**<a command on the command list is being executed*/

                      showing,               /**<it's downloading and showing a mail*/

                      refreshing             /**<it's refreshing the mail lists*/
     };

     /**
      * State of an account.
      */
     enum AccountState_Type
     {
       AccountIdle,         /**<it's doing nothing*/

       AccountDeleting,     /**<a deletion is running*/

       AccountDownloading,  /**<the account is downloading mail bodies*/

       AccountRefreshing    /**<the account is refreshing its mail list*/
     };

     /**
      * List of mail numbers. It is a TQValueList of integers.
      */
     typedef TQValueList<int> MailNumberList_Type;

     /**
      * Map to notice which accounts need to get an order to do a task.
      * The Key is the account name and the data a boolean.
      * TRUE means the task was ordered, FALSE the task was ended.
      */
     typedef TQMap<TQString, bool> AccountTaskMap_Type;

    /**
     * Actions returned by filters.
     */
     enum FilterAction_Type
     {
       FActPass,           /**<Mail has passed the filter check. It can showed in the list.*/
       FActDelete,         /**<Undesirable mail. Delete it.*/
       FActMark,           /**<Probably undesirable mail. Mark it in the mail list.*/
       FActMove,           /**<Move the mail to a certain mail box. The name of the box will returned by a further parameter.*/
       FActSpamcheck,      /**<This mail shall be forwared to a spam filter, which checks the whole mail including body.*/
       FActIgnore,         /**<This mail shall not be shown.*/
       FActNone            /**<The mail doesn't match up with the filter. Perform the next one.*/
     };

     /**
      * This struct is for use in MailToDownloadMap_Type and holds some parameters about the mail for
      * downloading.
      */
     struct DownloadActionParams_Type
     {
       FilterAction_Type action;  /**<the filter action*/
       TQString mailbox;            /**<name of the mailbox if action is MOVE*/
     };

     /**
      * This map is used by ConfigElem and ShowRecord to hold a list of mail numbers which shall be downloaded for
      * some filter actions; at time for moving and spam check
      */
     typedef TQMap<int, DownloadActionParams_Type> MailToDownloadMap_Type;

    /**
     * Contains all values of a filter criteria.
     */
     struct FilterCriteria_Type
     {
       int source;       /**<Object of comparison; see constants.h for valid values. (CONFIG_VALUE_FILTER_CRITERIA_SOURCE...)*/
       int condition;    /**<Condition of the comparison. see constants.h for valid values. (CONFIG_VALUE_FILTER_CRITERIA_COND...)*/
       uint numValue;    /**<Value of a numeric criteria, e.g. Size*/
       TQString txtValue; /**<Value of a text criteria, e.g. Subject*/
       bool cs;          /**<TRUE - Comparison is case sensitive. Just used for numeric criteria.*/
     };

    /**
     * List of filter criterias.
     */
    typedef list<FilterCriteria_Type> FilterCriteriaList_Type;

}

#endif
