/***************************************************************************
 *   Copyright (C) 2007 by Michael Zanetti  
 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/


#include <tdeaction.h>
#include <tdelocale.h>
#include <tdeactionclasses.h>
#include <kopetechatsession.h>
#include <kopeteview.h>
#include <kopetemessage.h>
#include <kdebug.h>
#include <kstandarddirs.h>
#include <tdemessagebox.h>


#include "otrguiclient.h"
#include "otrplugin.h"

/**
  * @author Frank Scheffold
  * @author Michael Zanetti
  */


OtrGUIClient::OtrGUIClient( Kopete::ChatSession *parent, const char *name )
: TQObject( parent, name ), KXMLGUIClient( parent )
{
	setInstance( OTRPlugin::plugin()->instance() );

	connect( OTRPlugin::plugin(),
		TQT_SIGNAL( destroyed( TQObject * ) ), this,
		TQT_SLOT( deleteLater() )

	);

	connect(this, TQT_SIGNAL( signalOtrChatsession(Kopete::ChatSession*, bool) ), OTRPlugin::plugin(), TQT_SLOT(slotEnableOtr(Kopete::ChatSession*, bool)));

	connect( OTRPlugin::plugin(), TQT_SIGNAL( goneSecure( Kopete::ChatSession *, int ) ),
	this, TQT_SLOT( encryptionEnabled( Kopete::ChatSession *, int ) ) );

	connect( this, TQT_SIGNAL( signalVerifyFingerprint( Kopete::ChatSession * ) ), OTRPlugin::plugin(), TQT_SLOT(slotVerifyFingerprint( Kopete::ChatSession * )) );

	m_manager = parent;
	otrActionMenu = new TDEActionMenu(i18n("OTR Settings"),"otr_disabled", actionCollection(), "otr_settings");
	otrActionMenu->setDelayed( false );
	actionEnableOtr = new TDEAction(i18n( "Start OTR session" ), "otr_private", 0,this,TQT_SLOT(slotEnableOtr()),actionCollection(), "enable_otr");
	actionDisableOtr = new TDEAction(i18n("End OTR session"), "otr_disabled",0, this,TQT_SLOT(slotDisableOtr()), actionCollection(), "disable_otr");
	actionVerifyFingerprint = new TDEAction(i18n("Authenticate Contact"), "signature",0, this,TQT_SLOT(slotVerifyFingerprint()), actionCollection(), "verify_fingerprint");

	otrActionMenu->insert(actionEnableOtr);
	otrActionMenu->insert(actionDisableOtr);
	otrActionMenu->insert(actionVerifyFingerprint);

	setXMLFile("otrchatui.rc");

	encryptionEnabled( parent, OtrlChatInterface::self()->privState(parent) );
    

}

OtrGUIClient::~OtrGUIClient()
{
}

void OtrGUIClient::slotEnableOtr()
{
	emit signalOtrChatsession( m_manager, true );
}
void OtrGUIClient::slotDisableOtr()
{
 	emit signalOtrChatsession( m_manager, false );
}

void OtrGUIClient::slotVerifyFingerprint(){
	emit signalVerifyFingerprint( m_manager );
}

void OtrGUIClient::encryptionEnabled(Kopete::ChatSession *session, int state){
	if( session == m_manager ){
		switch(state){
			case 0:
				otrActionMenu->setIcon("otr_disabled");
				actionEnableOtr->setText( i18n("Start OTR session") );
				actionDisableOtr->setEnabled(false);
				actionVerifyFingerprint->setEnabled(false);
				break;
			case 1:
				otrActionMenu->setIcon("otr_unverified");
				actionEnableOtr->setText( i18n("Refresh OTR session") );
				actionDisableOtr->setEnabled(true);
				actionVerifyFingerprint->setEnabled(true);
				break;
			case 2:
				otrActionMenu->setIcon("otr_private");
				actionEnableOtr->setText( i18n("Refresh OTR session") );
				actionDisableOtr->setEnabled(true);
				actionVerifyFingerprint->setEnabled(true);
				break;
			case 3:
				otrActionMenu->setIcon("otr_finished");
				actionEnableOtr->setText( i18n("Start OTR session") );
				actionDisableOtr->setEnabled(true);
				actionVerifyFingerprint->setEnabled(false);
				break;
		}
	}
}

#include "otrguiclient.moc"

// vim: set noet ts=4 sts=4 sw=4:
