/*
   Kontact's Link IRC Nick to Addressbook contact Wizard

   This code was shamelessly stolen from kopete's add new contact wizard.

    Copyright (c) 2004 by John Tapsell           <john@geola.co.uk>

    Copyright (c) 2003 by Will Stephenson        <will@stevello.free-online.co.uk>
    Copyright (c) 2002 by Nick Betcher           <nbetcher@kde.org>
    Copyright (c) 2002 by Duncan Mac-Vicar Prett <duncan@kde.org>

Kopete    (c) 2002-2004 by the Kopete developers  <kopete-devel@kde.org>

*************************************************************************
*                                                                       *
* This program is free software; you can redistribute it and/or modify  *
* it under the terms of the GNU General Public License as published by  *
* the Free Software Foundation; either version 2 of the License, or     *
* (at your option) any later version.                                   *
*                                                                       *
*************************************************************************
*/

#include "linkaddressbookui.h"
#include "addressbook.h"
#include "linkaddressbookui_base.h"
#include "addresseeitem.h"

#include <tqcheckbox.h>
#include <tqlabel.h>
#include <tqlayout.h>
#include <tqtooltip.h>
#include <tqwhatsthis.h>

#include <tdeapplication.h>
#include <tdeconfig.h>
#include <tdelocale.h>
#include <kiconloader.h>
#include <tdeversion.h>
#include <kinputdialog.h>
#include <kpushbutton.h>
#include <kactivelabel.h>
#include <kdebug.h>
#include <tdelistview.h>
#include <tdelistviewsearchline.h>
#include <tdeabc/addressbook.h>
#include <tdeabc/stdaddressbook.h>


LinkAddressbookUI::LinkAddressbookUI( TQWidget *parent, const char *name, const TQString &ircnick, const TQString &servername, const TQString &servergroup, const TQString &suggested_realname )
: KDialogBase(Plain, i18n("Link IRC Nick to Addressbook Contact"), Ok|Cancel|Help, Ok, parent, name)
{
    TQFrame* page = plainPage();
    TQGridLayout* pageLayout = new TQGridLayout(page, 1, 1, 0, 0);
    m_mainWidget = new LinkAddressbookUI_Base(page);
    pageLayout->addWidget(m_mainWidget, 0, 0);

    enableButtonOK(false);
    setHelp("linkaddressbook");
    m_addressBook = Konversation::Addressbook::self()->getAddressBook();

    // Addressee validation connections
    connect( m_mainWidget->addAddresseeButton, TQT_SIGNAL( clicked() ), TQT_SLOT( slotAddAddresseeClicked() ) );
    connect( m_mainWidget->addresseeListView, TQT_SIGNAL( clicked(TQListViewItem * ) ),
        TQT_SLOT( slotAddresseeListClicked( TQListViewItem * ) ) );
    connect( m_mainWidget->addresseeListView, TQT_SIGNAL( selectionChanged( TQListViewItem * ) ),
        TQT_SLOT( slotAddresseeListClicked( TQListViewItem * ) ) );
    connect( m_mainWidget->addresseeListView, TQT_SIGNAL( spacePressed( TQListViewItem * ) ),
        TQT_SLOT( slotAddresseeListClicked( TQListViewItem * ) ) );

    connect( m_addressBook, TQT_SIGNAL( addressBookChanged( AddressBook * ) ), this, TQT_SLOT( slotLoadAddressees() ) );
    connect( Konversation::Addressbook::self(), TQT_SIGNAL(addresseesChanged()), this, TQT_SLOT(slotLoadAddressees()));

    //We should add a clear TDEAction here.  But we can't really do that with a designer file :\  this sucks

    m_ircnick = ircnick;
    m_lower_ircnick = m_ircnick.lower();
    m_servername = servername;
    m_servergroup = servergroup;
    m_suggested_realname = suggested_realname;

    m_mainWidget->addresseeListView->setColumnText(2, SmallIconSet("email"), i18n("Email") );

    if(m_suggested_realname.isEmpty()) m_suggested_realname = suggested_realname;
    Q_ASSERT(!ircnick.isEmpty());
    m_mainWidget->kListViewSearchLine->setListView(m_mainWidget->addresseeListView);
    slotLoadAddressees();

    m_mainWidget->addresseeListView->setColumnWidthMode(0, TQListView::Manual);
                                                  //Photo is 60, and it's nice to have a small gap, imho
    m_mainWidget->addresseeListView->setColumnWidth(0, 63);

}

LinkAddressbookUI::~LinkAddressbookUI()
{
}

/**  Read in contacts from addressbook, and select the contact that is for our nick. */
void LinkAddressbookUI::slotLoadAddressees()
{
    m_mainWidget->addresseeListView->clear();

    TQString realname;
    int num_contacts_with_nick=0;                 //There shouldn't be more than 1 contact with this irc nick.  Warn the user if there is.

    TDEABC::AddressBook::Iterator it;
    for( it = m_addressBook->begin(); it != m_addressBook->end(); ++it )
        if(Konversation::Addressbook::self()->hasNick(*it, m_lower_ircnick, m_servername, m_servergroup))
    {
        realname = (*it).realName();
        num_contacts_with_nick++;
        (new AddresseeItem( m_mainWidget->addresseeListView, (*it) ))->setSelected(true);
    } else
    /*AddresseeItem *item =*/ new AddresseeItem( m_mainWidget->addresseeListView, (*it));

    if(num_contacts_with_nick == 0)
        m_mainWidget->lblHeader->setText(i18n("Choose the person who '%1' is.").arg(m_ircnick));
    else if(num_contacts_with_nick == 1 && realname.isEmpty())
        m_mainWidget->lblHeader->setText(i18n("Currently '%1' is associated with a contact.").arg(m_ircnick));
    else if(num_contacts_with_nick == 1 && !realname.isEmpty())
        m_mainWidget->lblHeader->setText(i18n("Currently '%1' is associated with contact '%2'.").arg(m_ircnick).arg(realname));
    else
        m_mainWidget->lblHeader->setText(i18n("<qt><b>Warning:</b> '%1' is currently being listed as belonging to multiple contacts.  Please select the correct contact.</qt>").arg(m_ircnick));

}

void LinkAddressbookUI::slotAddAddresseeClicked()
{
    // Pop up add addressee dialog
    if(!Konversation::Addressbook::self()->getAndCheckTicket()) return;
    TQString addresseeName = KInputDialog::getText( i18n( "New Address Book Entry" ),
        i18n( "Name the new entry:" ),
        m_suggested_realname, 0, this );

    if ( !addresseeName.isEmpty() )
    {
        TDEABC::Addressee addr;
        addr.setNameFromString( addresseeName );
        m_addressBook->insertAddressee(addr);
        Konversation::Addressbook::self()->saveTicket();
        slotLoadAddressees();
    }
    else
    {
        Konversation::Addressbook::self()->releaseTicket();
    }
}

void LinkAddressbookUI::slotAddresseeListClicked( TQListViewItem *addressee )
{
    // enable ok if a valid addressee is selected
    enableButtonOK(addressee ? addressee->isSelected() : false);
}

void LinkAddressbookUI::slotOk()
{
    //// set the KABC uid in the metacontact
    AddresseeItem *item = 0L;
    item = static_cast<AddresseeItem *>( m_mainWidget->addresseeListView->selectedItem() );

    TDEABC::Addressee addr;
    if ( item )
    {

        addr = item->addressee();
        if(!Konversation::Addressbook::self()->getAndCheckTicket())
        {
            return;
        }
        Konversation::Addressbook::self()->associateNickAndUnassociateFromEveryoneElse(addr, m_ircnick, m_servername, m_servergroup);
        if(!Konversation::Addressbook::self()->saveTicket())
        {
            return;
        }
    }
    disconnect( m_addressBook, TQT_SIGNAL( addressBookChanged( AddressBook * ) ), this, TQT_SLOT( slotLoadAddressees() ) );
    deleteLater();
    accept();
}

void LinkAddressbookUI::slotCancel()
{
    disconnect( m_addressBook, TQT_SIGNAL( addressBookChanged( AddressBook * ) ), this, TQT_SLOT( slotLoadAddressees() ) );
    deleteLater();
    reject();
}

#include "linkaddressbookui.moc"

// vim: set noet ts=4 sts=4 sw=4:
