/* This file is part of the KDE project
   Copyright (C) 2000 Matthias Kalle Dalheimer <kalle@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef __KCHARTBACKGROUNDPIXMAPCONFIGPAGE_H__
#define __KCHARTBACKGROUNDPIXMAPCONFIGPAGE_H__

#include <tqwidget.h>
#include <tqpixmap.h>
#include <tqvgroupbox.h>

class TQSpinBox;
class TQRadioButton;
class TQComboBox;
class TQPixmap;
class TQListBox;
class KColorButton;

namespace KChart
{

class KChartParams;

class KChartBackgroundPixmapConfigPage : public TQWidget
{
    Q_OBJECT
  

public:
    KChartBackgroundPixmapConfigPage( KChartParams* params,
                                      TQWidget* parent );
    void init();
    void apply();

private slots:
    void showSettings( const TQString& );
    void slotBrowse();
    void slotWallPaperChanged( int );

private:
    bool loadWallPaper();
    void loadWallpaperFilesList();
    KChartParams* _params;
    TQComboBox* wallCB;
    TQWidget* wallWidget;
    TQSpinBox* intensitySB;
    TQRadioButton* stretchedRB;
    TQRadioButton* scaledRB;
    TQRadioButton* centeredRB;
    TQRadioButton* tiledRB;
    TQString wallFile;
    TQPixmap wallPixmap;
#if 0
    TQListBox *regionList;
#endif
    KColorButton* _backgroundCB;
    TQVGroupBox* right;
    TQMap<TQString,int> m_wallpaper;
};

}  //KChart namespace

#endif
